/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.agent.studio.dto.messages;

import com.alibaba.cloud.ai.agent.studio.dto.messages.MessageDTO;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.ai.chat.messages.AssistantMessage;

public class AssistantMessageDTO
implements MessageDTO {
    @JsonProperty(value="messageType")
    private String messageType = "assistant";
    @JsonProperty(value="content")
    private String content;
    @JsonProperty(value="metadata")
    private Map<String, Object> metadata = new HashMap<String, Object>();
    @JsonProperty(value="toolCalls")
    private List<ToolCallDTO> toolCalls = new ArrayList<ToolCallDTO>();

    public AssistantMessageDTO() {
    }

    public AssistantMessageDTO(String content) {
        this();
        this.content = content;
    }

    public AssistantMessageDTO(AssistantMessage message) {
        this();
        this.content = message.getText();
        this.metadata = new HashMap<String, Object>(message.getMetadata());
        if (message.getToolCalls() != null && !message.getToolCalls().isEmpty()) {
            this.toolCalls = new ArrayList<ToolCallDTO>();
            for (AssistantMessage.ToolCall toolCall : message.getToolCalls()) {
                this.toolCalls.add(new ToolCallDTO(toolCall));
            }
        }
    }

    public AssistantMessage toAssistantMessage() {
        ArrayList<AssistantMessage.ToolCall> springToolCalls = new ArrayList<AssistantMessage.ToolCall>();
        if (this.toolCalls != null) {
            for (ToolCallDTO dto : this.toolCalls) {
                springToolCalls.add(dto.toToolCall());
            }
        }
        return new AssistantMessage(this.content, this.metadata, springToolCalls);
    }

    @Override
    public String getMessageType() {
        return this.messageType;
    }

    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }

    @Override
    public String getContent() {
        return this.content;
    }

    public void setContent(String content) {
        this.content = content;
    }

    public Map<String, Object> getMetadata() {
        return this.metadata;
    }

    public void setMetadata(Map<String, Object> metadata) {
        this.metadata = metadata;
    }

    public List<ToolCallDTO> getToolCalls() {
        return this.toolCalls;
    }

    public void setToolCalls(List<ToolCallDTO> toolCalls) {
        this.toolCalls = toolCalls;
    }

    public static class ToolCallDTO {
        @JsonProperty(value="id")
        private String id;
        @JsonProperty(value="type")
        private String type;
        @JsonProperty(value="name")
        private String name;
        @JsonProperty(value="arguments")
        private String arguments;

        public ToolCallDTO() {
        }

        public ToolCallDTO(AssistantMessage.ToolCall toolCall) {
            this.id = toolCall.id();
            this.type = toolCall.type();
            this.name = toolCall.name();
            this.arguments = toolCall.arguments();
        }

        public AssistantMessage.ToolCall toToolCall() {
            return new AssistantMessage.ToolCall(this.id, this.type, this.name, this.arguments);
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id) {
            this.id = id;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public String getArguments() {
            return this.arguments;
        }

        public void setArguments(String arguments) {
            this.arguments = arguments;
        }
    }
}

