/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.agent.studio.dto.messages;

import com.alibaba.cloud.ai.agent.studio.dto.messages.MessageDTO;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.metadata.Usage;

public class AgentRunResponse {
    @JsonProperty(value="node")
    protected String node;
    @JsonProperty(value="agent")
    protected String agent;
    @JsonProperty(value="tokenUsage")
    protected Usage tokenUsage;
    @JsonProperty(value="message")
    protected MessageDTO message;
    @JsonProperty(value="chunk")
    private String chunk;

    AgentRunResponse() {
    }

    public AgentRunResponse(String node, String agent, Message message, Usage tokenUsage, String chunk) {
        this.node = node;
        this.agent = agent;
        this.message = message != null ? MessageDTO.MessageDTOFactory.fromMessage(message) : null;
        this.tokenUsage = tokenUsage;
        this.chunk = chunk;
    }

    public AgentRunResponse(String node, String agent, MessageDTO message, Usage tokenUsage, String chunk) {
        this.node = node;
        this.agent = agent;
        this.message = message;
        this.tokenUsage = tokenUsage;
        this.chunk = chunk;
    }

    public String getNode() {
        return this.node;
    }

    public void setNode(String node) {
        this.node = node;
    }

    public String getAgent() {
        return this.agent;
    }

    public void setAgent(String agent) {
        this.agent = agent;
    }

    public Usage getTokenUsage() {
        return this.tokenUsage;
    }

    public void setTokenUsage(Usage tokenUsage) {
        this.tokenUsage = tokenUsage;
    }

    public MessageDTO getMessage() {
        return this.message;
    }

    public void setMessage(MessageDTO message) {
        this.message = message;
    }

    @JsonIgnore
    public Message getMessageAsSpringAI() {
        return this.message != null ? MessageDTO.MessageDTOFactory.toMessage(this.message) : null;
    }

    public String getChunk() {
        return this.chunk;
    }

    public void setChunk(String chunk) {
        this.chunk = chunk;
    }
}

