/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.agent.studio.dto;

import com.alibaba.cloud.ai.agent.studio.dto.messages.MessageDTO;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.google.errorprone.annotations.CanIgnoreReturnValue;
import java.util.Map;

@JsonDeserialize(builder=Builder.class)
public final class Thread {
    private final String threadId;
    private final String appName;
    private final String userId;
    private final Map<String, MessageDTO> values;

    private Thread(String threadId, String appName, String userId, Map<String, MessageDTO> values) {
        this.threadId = threadId;
        this.appName = appName;
        this.userId = userId;
        this.values = values;
    }

    public static Builder builder(String id) {
        return new Builder(id);
    }

    @JsonProperty(value="thread_id")
    public String threadId() {
        return this.threadId;
    }

    @JsonProperty(value="appName")
    public String appName() {
        return this.appName;
    }

    @JsonProperty(value="userId")
    public String userId() {
        return this.userId;
    }

    @JsonProperty(value="values")
    public Map<String, MessageDTO> values() {
        return this.values;
    }

    public String toString() {
        return "";
    }

    public static final class Builder {
        private String threadId;
        private String appName;
        private String userId;
        private Map<String, MessageDTO> values;

        public Builder(String threadId) {
            this.threadId = threadId;
        }

        @JsonCreator
        private Builder() {
        }

        @JsonProperty(value="thread_id")
        @CanIgnoreReturnValue
        public Builder threadId(String threadId) {
            this.threadId = threadId;
            return this;
        }

        @JsonProperty(value="appName")
        @CanIgnoreReturnValue
        public Builder appName(String appName) {
            this.appName = appName;
            return this;
        }

        @JsonProperty(value="userId")
        @CanIgnoreReturnValue
        public Builder userId(String userId) {
            this.userId = userId;
            return this;
        }

        @JsonProperty(value="values")
        @CanIgnoreReturnValue
        public Builder values(Map<String, MessageDTO> values) {
            this.values = values;
            return this;
        }

        public Thread build() {
            if (this.threadId == null) {
                throw new IllegalStateException("Thread id is null");
            }
            return new Thread(this.threadId, this.appName, this.userId, this.values);
        }
    }
}

