/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.agent.studio.controller;

import com.alibaba.cloud.ai.agent.studio.dto.ListThreadsResponse;
import com.alibaba.cloud.ai.agent.studio.dto.Thread;
import com.alibaba.cloud.ai.agent.studio.service.ThreadService;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
public class ThreadController {
    private static final Logger log = LoggerFactory.getLogger(ThreadController.class);
    private static final String EVAL_SESSION_ID_PREFIX = "SAA_EVAL_";
    private final ThreadService threadService;

    @Autowired
    public ThreadController(ThreadService threadService) {
        this.threadService = threadService;
    }

    private Thread findThreadOrThrow(String appName, String userId, String threadId) {
        Optional optionalThread = (Optional)this.threadService.getThread(appName, userId, threadId, Optional.empty()).block();
        if (optionalThread == null || !optionalThread.isPresent()) {
            log.warn("Thread not found for appName={}, userId={}, threadId={}", new Object[]{appName, userId, threadId});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, String.format("Thread not found: appName=%s, userId=%s, threadId=%s", appName, userId, threadId));
        }
        Thread thread = (Thread)optionalThread.get();
        if (!Objects.equals(thread.appName(), appName) || !Objects.equals(thread.userId(), userId)) {
            log.warn("Thread ID {} found but appName/userId mismatch (Expected: {}/{}, Found: {}/{}) - Treating as not found.", new Object[]{threadId, appName, userId, thread.appName(), thread.userId()});
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.NOT_FOUND, "Thread found but belongs to a different app/user.");
        }
        log.debug("Found thread: {}", (Object)threadId);
        return thread;
    }

    @GetMapping(value={"/apps/{appName}/users/{userId}/threads/{threadId}"})
    public Thread getThread(@PathVariable String appName, @PathVariable String userId, @PathVariable String threadId) {
        log.info("Request received for GET /apps/{}/users/{}/threads/{}", new Object[]{appName, userId, threadId});
        return this.findThreadOrThrow(appName, userId, threadId);
    }

    @GetMapping(value={"/apps/{appName}/users/{userId}/threads"})
    public List<Thread> listThreads(@PathVariable String appName, @PathVariable String userId) {
        log.info("Request received for GET /apps/{}/users/{}/threads", (Object)appName, (Object)userId);
        ListThreadsResponse response = (ListThreadsResponse)this.threadService.listThreads(appName, userId).block();
        if (response == null || response.threads() == null) {
            log.warn("Received null response or null threads list for listThreads({}, {})", (Object)appName, (Object)userId);
            return Collections.emptyList();
        }
        List<Thread> filteredThreads = response.threads().stream().filter(s -> !s.threadId().startsWith(EVAL_SESSION_ID_PREFIX)).collect(Collectors.toList());
        log.info("Found {} non-evaluation thread for app={}, user={}", new Object[]{filteredThreads.size(), appName, userId});
        return filteredThreads;
    }

    @PostMapping(value={"/apps/{appName}/users/{userId}/threads/{threadId}"})
    public Thread createThreadWithId(@PathVariable String appName, @PathVariable String userId, @PathVariable String threadId, @RequestBody(required=false) Map<String, Object> state) {
        log.info("Request received for POST /apps/{}/users/{}/threads/{} with state: {}", new Object[]{appName, userId, threadId, state});
        try {
            this.findThreadOrThrow(appName, userId, threadId);
            log.warn("Attempted to create thread with existing ID: {}", (Object)threadId);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "Thread already exists: " + threadId);
        }
        catch (ResponseStatusException e) {
            if (e.getStatusCode() != HttpStatus.NOT_FOUND) {
                throw e;
            }
            log.info("Thread {} not found, proceeding with creation.", (Object)threadId);
            Map<String, Object> initialState = state != null ? state : Collections.emptyMap();
            try {
                Thread createdThread = (Thread)this.threadService.createThread(appName, userId, new ConcurrentHashMap<String, Object>(initialState), threadId).block();
                if (createdThread == null) {
                    log.error("Thread creation call completed without error but returned null thread for {}", (Object)threadId);
                    throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to create thread (null result)");
                }
                log.info("Thread created successfully with id: {}", (Object)createdThread.threadId());
                return createdThread;
            }
            catch (Exception e2) {
                log.error("Error creating thread with id {}", (Object)threadId, (Object)e2);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error creating thread", (Throwable)e2);
            }
        }
    }

    @PostMapping(value={"/apps/{appName}/users/{userId}/threads"})
    public Thread createThread(@PathVariable String appName, @PathVariable String userId, @RequestBody(required=false) Map<String, Object> state) {
        log.info("Request received for POST /apps/{}/users/{}/threads (service generates ID) with state: {}", new Object[]{appName, userId, state});
        Map<String, Object> initialState = state != null && !state.isEmpty() ? state : null;
        try {
            Thread createdThread = (Thread)this.threadService.createThread(appName, userId, (Map<String, Object>)(initialState != null ? new ConcurrentHashMap<String, Object>(initialState) : null), null).block();
            if (createdThread == null) {
                log.error("Thread creation call completed without error but returned null thread for user {}", (Object)userId);
                throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Failed to create thread (null result)");
            }
            log.info("Thread created successfully with generated id: {}", (Object)createdThread.threadId());
            return createdThread;
        }
        catch (Exception e) {
            log.error("Error creating thread for user {}", (Object)userId, (Object)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error creating thread", (Throwable)e);
        }
    }

    @DeleteMapping(value={"/apps/{appName}/users/{userId}/threads/{threadId}"})
    public ResponseEntity<Void> deleteThread(@PathVariable String appName, @PathVariable String userId, @PathVariable String threadId) {
        log.info("Request received for DELETE /apps/{}/users/{}/threads/{}", new Object[]{appName, userId, threadId});
        try {
            this.threadService.deleteThread(appName, userId, threadId).block();
            log.info("Thread deleted successfully: {}", (Object)threadId);
            return ResponseEntity.noContent().build();
        }
        catch (Exception e) {
            log.error("Error deleting thread {}", (Object)threadId, (Object)e);
            throw new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Error deleting thread", (Throwable)e);
        }
    }
}

