/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.agent.studio.controller;

import com.alibaba.cloud.ai.agent.studio.dto.AgentResumeRequest;
import com.alibaba.cloud.ai.agent.studio.dto.AgentRunRequest;
import com.alibaba.cloud.ai.agent.studio.dto.messages.AgentRunResponse;
import com.alibaba.cloud.ai.agent.studio.dto.messages.MessageDTO;
import com.alibaba.cloud.ai.agent.studio.dto.messages.ToolRequestConfirmMessageDTO;
import com.alibaba.cloud.ai.agent.studio.loader.AgentLoader;
import com.alibaba.cloud.ai.graph.RunnableConfig;
import com.alibaba.cloud.ai.graph.action.InterruptionMetadata;
import com.alibaba.cloud.ai.graph.agent.BaseAgent;
import com.alibaba.cloud.ai.graph.exception.GraphRunnerException;
import com.alibaba.cloud.ai.graph.streaming.StreamingOutput;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.ai.chat.messages.AssistantMessage;
import org.springframework.ai.chat.messages.Message;
import org.springframework.ai.chat.messages.UserMessage;
import org.springframework.ai.chat.metadata.Usage;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.HttpStatusCode;
import org.springframework.http.codec.ServerSentEvent;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;
import reactor.core.publisher.Flux;

@RestController
public class ExecutionController {
    private static final Logger log = LoggerFactory.getLogger(ExecutionController.class);
    final ObjectMapper mapper = new ObjectMapper();
    private final AgentLoader agentLoader;

    @Autowired
    public ExecutionController(AgentLoader agentLoader) {
        this.agentLoader = agentLoader;
    }

    @PostMapping(value={"/run_sse"}, produces={"text/event-stream"})
    public Flux<ServerSentEvent<String>> agentRunSse(@RequestBody AgentRunRequest request) {
        if (request.appName == null || request.appName.trim().isEmpty()) {
            log.warn("appName cannot be null or empty in SSE request for appName: {}, session: {}", (Object)request.appName, (Object)request.threadId);
            return Flux.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "appName cannot be null or empty"));
        }
        if (request.threadId == null || request.threadId.trim().isEmpty()) {
            log.warn("threadId cannot be null or empty in SSE request for appName: {}, session: {}", (Object)request.appName, (Object)request.threadId);
            return Flux.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "threadId cannot be null or empty"));
        }
        try {
            BaseAgent agent = this.agentLoader.loadAgent(request.appName);
            RunnableConfig runnableConfig = ((RunnableConfig.Builder)RunnableConfig.builder().threadId(request.threadId).addMetadata("user_id", (Object)request.userId)).build();
            return this.executeAgent(request.newMessage.toUserMessage(), agent, runnableConfig);
        }
        catch (Exception e) {
            log.error("Error during agent run for session {}", (Object)request.threadId, (Object)e);
            return Flux.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Agent run failed", (Throwable)e));
        }
    }

    @PostMapping(value={"/resume_sse"}, produces={"text/event-stream"})
    public Flux<ServerSentEvent<String>> agentResumeSse(@RequestBody AgentResumeRequest request) {
        if (request.appName == null || request.appName.trim().isEmpty()) {
            log.warn("appName cannot be null or empty in SSE request for appName: {}, session: {}", (Object)request.appName, (Object)request.threadId);
            return Flux.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "appName cannot be null or empty"));
        }
        if (request.threadId == null || request.threadId.trim().isEmpty()) {
            log.warn("threadId cannot be null or empty in SSE request for appName: {}, session: {}", (Object)request.appName, (Object)request.threadId);
            return Flux.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.BAD_REQUEST, "threadId cannot be null or empty"));
        }
        try {
            BaseAgent agent = this.agentLoader.loadAgent(request.appName);
            InterruptionMetadata.Builder metadataBuilder = InterruptionMetadata.builder();
            if (request.toolFeedbacks != null && !request.toolFeedbacks.isEmpty()) {
                for (ToolRequestConfirmMessageDTO.ToolFeedback toolFeedback : request.toolFeedbacks) {
                    InterruptionMetadata.ToolFeedback.FeedbackResult result = toolFeedback.getResult() != null ? InterruptionMetadata.ToolFeedback.FeedbackResult.valueOf((String)toolFeedback.getResult().name()) : InterruptionMetadata.ToolFeedback.FeedbackResult.APPROVED;
                    InterruptionMetadata.ToolFeedback feedback = new InterruptionMetadata.ToolFeedback(toolFeedback.getId(), toolFeedback.getName(), toolFeedback.getArguments(), result, toolFeedback.getDescription());
                    metadataBuilder.addToolFeedback(feedback);
                }
            }
            RunnableConfig runnableConfig = ((RunnableConfig.Builder)RunnableConfig.builder().threadId(request.threadId).addMetadata("user_id", (Object)request.userId)).addHumanFeedback(metadataBuilder.build()).build();
            return this.executeAgent(null, agent, runnableConfig);
        }
        catch (Exception e) {
            log.error("Error during agent run for session {}", (Object)request.threadId, (Object)e);
            return Flux.error((Throwable)new ResponseStatusException((HttpStatusCode)HttpStatus.INTERNAL_SERVER_ERROR, "Agent run failed", (Throwable)e));
        }
    }

    @NotNull
    private Flux<ServerSentEvent<String>> executeAgent(UserMessage userMessage, BaseAgent agent, RunnableConfig runnableConfig) throws GraphRunnerException {
        Flux agentStream = userMessage != null ? agent.stream(userMessage, runnableConfig) : agent.stream("", runnableConfig);
        return agentStream.map(nodeOutput -> {
            String node = nodeOutput.node();
            String agentName = nodeOutput.agent();
            Usage tokenUsage = nodeOutput.tokenUsage();
            StringBuilder chunkBuilder = new StringBuilder();
            AgentRunResponse agentResponse = null;
            if (nodeOutput instanceof StreamingOutput) {
                AssistantMessage assistantMessage;
                StreamingOutput streamingOutput = (StreamingOutput)nodeOutput;
                Message message = streamingOutput.message();
                if (message == null) {
                    return ServerSentEvent.builder().data((Object)"{}").build();
                }
                agentResponse = message instanceof AssistantMessage ? ((assistantMessage = (AssistantMessage)message).hasToolCalls() ? new AgentRunResponse(node, agentName, (Message)assistantMessage, tokenUsage, "") : new AgentRunResponse(node, agentName, (Message)assistantMessage, tokenUsage, assistantMessage.getText())) : new AgentRunResponse(node, agentName, message, tokenUsage, "");
            } else if (nodeOutput instanceof InterruptionMetadata) {
                InterruptionMetadata interruptionMetadata = (InterruptionMetadata)nodeOutput;
                ToolRequestConfirmMessageDTO toolRequestMessage = MessageDTO.MessageDTOFactory.fromInterruptionMetadata(interruptionMetadata);
                agentResponse = new AgentRunResponse(node, agentName, toolRequestMessage, tokenUsage, "");
            }
            try {
                if (agentResponse != null) {
                    String jsonData = this.mapper.writeValueAsString(agentResponse);
                    return ServerSentEvent.builder().data((Object)jsonData).build();
                }
            }
            catch (Exception e) {
                log.error("Failed to serialize AgentRunResponse to JSON", (Throwable)e);
                return ServerSentEvent.builder().data((Object)"{\"error\":\"Failed to serialize response\"}").build();
            }
            return ServerSentEvent.builder().data((Object)"{}").build();
        }).onErrorResume(error -> {
            log.error("Error occurred during agent stream execution", error);
            String errorMessage = error.getMessage() != null ? error.getMessage() : "Unknown error occurred";
            String errorType = error.getClass().getSimpleName();
            try {
                String errorJson = String.format("{\"error\":true,\"errorType\":\"%s\",\"errorMessage\":\"%s\"}", errorType.replace("\"", "\\\""), errorMessage.replace("\"", "\\\"").replace("\n", "\\n"));
                return Flux.just((Object)ServerSentEvent.builder().event("error").data((Object)errorJson).build());
            }
            catch (Exception e) {
                log.error("Failed to create error SSE event", (Throwable)e);
                return Flux.just((Object)ServerSentEvent.builder().event("error").data((Object)"{\"error\":true,\"errorMessage\":\"Internal error occurred\"}").build());
            }
        });
    }
}

