/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.cloud.ai.document;

import com.alibaba.cloud.ai.document.DocumentParser;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.StreamSupport;
import org.springframework.ai.document.Document;
import org.springframework.ai.reader.EmptyJsonMetadataGenerator;
import org.springframework.ai.reader.JsonMetadataGenerator;

public class JsonDocumentParser
implements DocumentParser {
    private final JsonMetadataGenerator jsonMetadataGenerator;
    private final ObjectMapper objectMapper = new ObjectMapper();
    private final List<String> jsonKeysToUse;

    public JsonDocumentParser(String ... jsonKeysToUse) {
        this((JsonMetadataGenerator)new EmptyJsonMetadataGenerator(), jsonKeysToUse);
    }

    public JsonDocumentParser(JsonMetadataGenerator jsonMetadataGenerator, String ... jsonKeysToUse) {
        Objects.requireNonNull(jsonKeysToUse, "keys must not be null");
        Objects.requireNonNull(jsonMetadataGenerator, "jsonMetadataGenerator must not be null");
        this.jsonMetadataGenerator = jsonMetadataGenerator;
        this.jsonKeysToUse = List.of(jsonKeysToUse);
    }

    @Override
    public List<Document> parse(InputStream inputStream) {
        try {
            JsonNode rootNode = this.objectMapper.readTree(inputStream);
            if (rootNode.isArray()) {
                return StreamSupport.stream(rootNode.spliterator(), true).map(jsonNode -> this.parseJsonNode((JsonNode)jsonNode, this.objectMapper)).toList();
            }
            return Collections.singletonList(this.parseJsonNode(rootNode, this.objectMapper));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private Document parseJsonNode(JsonNode jsonNode, ObjectMapper objectMapper) {
        Map item = (Map)objectMapper.convertValue((Object)jsonNode, (TypeReference)new TypeReference<Map<String, Object>>(){});
        StringBuilder sb = new StringBuilder();
        this.jsonKeysToUse.stream().filter(item::containsKey).forEach(key -> sb.append((String)key).append(": ").append(item.get(key)).append(System.lineSeparator()));
        Map metadata = this.jsonMetadataGenerator.generate(item);
        String content = sb.isEmpty() ? item.toString() : sb.toString();
        return new Document(content, metadata);
    }

    protected List<Document> get(JsonNode rootNode) {
        if (rootNode.isArray()) {
            return StreamSupport.stream(rootNode.spliterator(), true).map(jsonNode -> this.parseJsonNode((JsonNode)jsonNode, this.objectMapper)).toList();
        }
        return Collections.singletonList(this.parseJsonNode(rootNode, this.objectMapper));
    }

    public List<Document> get(String pointer, InputStream inputStream) {
        try {
            JsonNode rootNode = this.objectMapper.readTree(inputStream);
            JsonNode targetNode = rootNode.at(pointer);
            if (targetNode.isMissingNode()) {
                throw new IllegalArgumentException("Invalid JSON Pointer: " + pointer);
            }
            return this.get(targetNode);
        }
        catch (IOException e) {
            throw new RuntimeException("Error reading JSON resource", e);
        }
    }
}

