/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.handler.impl.error;

import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.component.EnvironmentVariablesComponent;
import com.alibaba.citrus.webx.handler.component.ExceptionComponent;
import com.alibaba.citrus.webx.handler.component.KeyValuesComponent;
import com.alibaba.citrus.webx.handler.component.RequestComponent;
import com.alibaba.citrus.webx.handler.component.SystemInfoComponent;
import com.alibaba.citrus.webx.handler.component.SystemPropertiesComponent;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import com.alibaba.citrus.webx.handler.support.LayoutRequestProcessor;
import com.alibaba.citrus.webx.util.ErrorHandlerHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DetailedErrorHandler
extends LayoutRequestProcessor {
    private static final Logger log = LoggerFactory.getLogger(DetailedErrorHandler.class);
    private final KeyValuesComponent keyValuesComponent = new KeyValuesComponent(this, "keyValues");
    private final ExceptionComponent exceptionComponent = new ExceptionComponent(this, "exception");
    private final RequestComponent requestComponent = new RequestComponent(this, "request", this.keyValuesComponent);
    private final SystemPropertiesComponent systemPropertiesComponent = new SystemPropertiesComponent(this, "sysprops", this.keyValuesComponent);
    private final EnvironmentVariablesComponent environmentVariablesComponent = new EnvironmentVariablesComponent(this, "env", this.keyValuesComponent);
    private final SystemInfoComponent systemInfoComponent = new SystemInfoComponent(this, "sysinfo", this.keyValuesComponent);

    @Override
    protected Object getBodyVisitor(RequestHandlerContext context) {
        ErrorHandlerHelper helper = ErrorHandlerHelper.getInstance(context.getRequest());
        helper.logError(log);
        return new DetailedErrorPageVisitor(context, helper);
    }

    @Override
    protected String getTitle(Object visitor) {
        ErrorHandlerHelper helper = ((DetailedErrorPageVisitor)visitor).helper;
        StringBuilder title = new StringBuilder();
        if (helper.getMessage() != null) {
            title.append(helper.getMessage());
        }
        title.append(": ").append(helper.getRequestURI());
        return title.toString();
    }

    private class DetailedErrorPageVisitor
    extends AbstractVisitor {
        private final ErrorHandlerHelper helper;
        private String componentResource;

        public DetailedErrorPageVisitor(RequestHandlerContext context, ErrorHandlerHelper helper) {
            super(context);
            this.helper = helper;
        }

        public void visitException() {
            if (this.helper.getException() != null) {
                DetailedErrorHandler.this.exceptionComponent.visitTemplate(this.context, this.helper.getException());
            }
        }

        public void visitRequest() {
            DetailedErrorHandler.this.requestComponent.visitTemplate(this.context);
        }

        public void visitSystemProperties() {
            DetailedErrorHandler.this.systemPropertiesComponent.visitTemplate(this.context);
        }

        public void visitSystemInfo() {
            DetailedErrorHandler.this.systemInfoComponent.visitTemplate(this.context);
        }

        public void visitEnv() {
            DetailedErrorHandler.this.environmentVariablesComponent.visitTemplate(this.context);
        }
    }
}

