/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.webx.handler.component;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.internal.webpagelite.PageComponent;
import com.alibaba.citrus.util.internal.webpagelite.PageComponentRegistry;
import com.alibaba.citrus.util.templatelite.Template;
import com.alibaba.citrus.webx.handler.RequestHandlerContext;
import com.alibaba.citrus.webx.handler.RequestHandlerMapping;
import com.alibaba.citrus.webx.handler.support.AbstractVisitor;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;

public class MenuComponent
extends PageComponent {
    @Autowired
    private RequestHandlerMapping internalHandlers;

    public MenuComponent(PageComponentRegistry registry, String componentPath) {
        super(registry, componentPath);
    }

    public void visitTemplate(RequestHandlerContext context, String selection) {
        this.getTemplate().accept(new MenuVisitor(context, this.createRootEntry(), selection));
    }

    private Entry createRootEntry() {
        Entry root = new Entry();
        for (String name : this.internalHandlers.getRequestHandlerNames()) {
            Entry entry = root;
            int index = name.indexOf(47);
            while (index >= 0) {
                String catName = name.substring(0, index + 1);
                entry = entry.getOrCreateSubEntry(catName);
                index = name.indexOf(47, index + 1);
            }
            entry.getOrCreateSubEntry(name);
        }
        return root;
    }

    private static class Entry {
        private final String path;
        private final String name;
        private final boolean category;
        private final boolean root;
        private Map<String, Entry> subEntries;

        private Entry() {
            this.path = "";
            this.name = "";
            this.category = true;
            this.root = true;
            this.subEntries = CollectionUtil.createTreeMap();
        }

        public Entry(String path) {
            this.path = path;
            this.category = path.endsWith("/");
            this.name = this.getName(path);
            this.root = false;
            this.subEntries = CollectionUtil.createTreeMap();
        }

        private String getName(String path) {
            int fromIndex = this.category ? path.length() - 2 : path.length();
            try {
                return StringEscapeUtil.unescapeURL(path.substring(path.lastIndexOf("/", fromIndex) + 1, path.length() - (this.category ? 1 : 0)), "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                Assert.unreachableCode();
                return null;
            }
        }

        public String getPath() {
            return this.path;
        }

        public String getName() {
            return this.name;
        }

        public boolean isCategory() {
            return this.category;
        }

        public boolean isRoot() {
            return this.root;
        }

        public Entry getOrCreateSubEntry(String path) {
            Entry subEntry = this.subEntries.get(path);
            if (subEntry == null) {
                subEntry = new Entry(path);
                this.subEntries.put(path, subEntry);
            }
            return subEntry;
        }

        public Collection<Entry> getSubEntries() {
            return this.subEntries.values();
        }

        public String toString() {
            return this.root ? "/" : this.path;
        }
    }

    private class ItemEntryVisitor
    extends AbstractEntryVisitor {
        public ItemEntryVisitor(RequestHandlerContext context, Entry entry) {
            super(context, entry);
        }

        public void visitItemUrl() {
            ((PrintWriter)this.out()).print(this.context.getInternalResourceURL(this.entry.getPath()));
        }

        public void visitItemName() {
            ((PrintWriter)this.out()).print(this.entry.getName());
        }
    }

    private class CatEntryVisitor
    extends AbstractEntryVisitor {
        public CatEntryVisitor(RequestHandlerContext context, Entry entry) {
            super(context, entry);
        }

        public void visitCatName() {
            ((PrintWriter)this.out()).print(this.entry.getName());
        }

        public void visitSubEntries(Template noSubEntriesTemplate, Template withSubEntriesTemplate) {
            if (this.entry.getSubEntries().isEmpty()) {
                noSubEntriesTemplate.accept(this);
            } else {
                withSubEntriesTemplate.accept(this);
            }
        }

        public void visitSubEntriesRecursive(Template catTemplate, Template itemTemplate) {
            for (Entry subEntry : this.entry.getSubEntries()) {
                if (subEntry.isCategory()) {
                    catTemplate.accept(new CatEntryVisitor(this.context, subEntry));
                    continue;
                }
                itemTemplate.accept(new ItemEntryVisitor(this.context, subEntry));
            }
        }
    }

    private abstract class AbstractEntryVisitor
    extends AbstractVisitor {
        protected final Entry entry;

        public AbstractEntryVisitor(RequestHandlerContext context, Entry entry) {
            super(context, MenuComponent.this);
            this.entry = entry;
        }
    }

    private class MenuVisitor
    extends AbstractVisitor {
        private final String selection;
        private final Entry rootEntry;

        public MenuVisitor(RequestHandlerContext context, Entry rootEntry, String selection) {
            super(context, MenuComponent.this);
            this.selection = selection;
            this.rootEntry = rootEntry;
        }

        public void visitEntry(Template homeTemplate, Template catTemplate, Template itemTemplate) {
            homeTemplate.accept(this);
            for (Entry subEntry : this.rootEntry.getSubEntries()) {
                if (subEntry.isCategory()) {
                    catTemplate.accept(new CatEntryVisitor(this.context, subEntry));
                    continue;
                }
                itemTemplate.accept(new ItemEntryVisitor(this.context, subEntry));
            }
        }

        public void visitInternalHomePage() {
            ((PrintWriter)this.out()).print(this.context.getInternalResourceURL("/"));
        }

        public void visitOriginalHomePage() {
            ((PrintWriter)this.out()).print(this.context.getInternalResourceURL("../") + "?home");
        }
    }
}

