/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;

abstract class NormalizableStringBuilder<B extends NormalizableStringBuilder<B>>
implements Appendable {
    protected static final char CR = '\r';
    protected static final char LF = '\n';
    private static final char NONE = '\u0000';
    private final StringBuilder out = new StringBuilder();
    private final String newLine;
    private int newLineStartIndex = 0;
    private char readAheadBuffer = '\u0000';

    public NormalizableStringBuilder() {
        this(null);
    }

    public NormalizableStringBuilder(String newLine) {
        this.newLine = ObjectUtil.defaultIfNull(newLine, String.valueOf('\n'));
    }

    public void clear() {
        this.out.setLength(0);
        this.newLineStartIndex = 0;
        this.readAheadBuffer = '\u0000';
    }

    public final int length() {
        return this.out.length();
    }

    public final int lineLength() {
        return this.out.length() - this.newLineStartIndex;
    }

    public final B append(CharSequence csq) {
        return (B)this.append(csq, 0, csq.length());
    }

    public final B append(CharSequence csq, int start, int end) {
        for (int i = start; i < end; ++i) {
            this.append(csq.charAt(i));
        }
        return this.thisObject();
    }

    public final B append(char c) {
        block0 : switch (this.readAheadBuffer) {
            case '\u0000': {
                switch (c) {
                    case '\r': {
                        this.readAheadBuffer = (char)13;
                        break block0;
                    }
                    case '\n': {
                        this.readAheadBuffer = '\u0000';
                        this.visit('\n');
                        break block0;
                    }
                }
                this.readAheadBuffer = '\u0000';
                this.visit(c);
                break;
            }
            case '\r': {
                switch (c) {
                    case '\r': {
                        this.readAheadBuffer = (char)13;
                        this.visit('\n');
                        break block0;
                    }
                    case '\n': {
                        this.readAheadBuffer = '\u0000';
                        this.visit('\n');
                        break block0;
                    }
                }
                this.readAheadBuffer = '\u0000';
                this.visit('\n');
                this.visit(c);
                break;
            }
            default: {
                Assert.unreachableCode();
            }
        }
        return this.thisObject();
    }

    protected abstract void visit(char var1);

    protected final void appendInternal(String s) {
        this.out.append(s);
    }

    protected final void appendInternal(char c) {
        this.out.append(c);
    }

    protected final void appendInternalNewLine() {
        this.out.append(this.newLine);
        this.newLineStartIndex = this.out.length();
    }

    public final boolean endsWith(String testStr) {
        if (testStr == null) {
            return false;
        }
        int testStrLength = testStr.length();
        int bufferLength = this.out.length();
        if (bufferLength < testStrLength) {
            return false;
        }
        int baseIndex = bufferLength - testStrLength;
        for (int i = 0; i < testStrLength; ++i) {
            if (this.out.charAt(baseIndex + i) == testStr.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public final boolean endsWithNewLine() {
        return this.out.length() == 0 || this.endsWith(this.newLine);
    }

    private B thisObject() {
        NormalizableStringBuilder buf = this;
        return (B)buf;
    }

    public final void flush() {
        if (this.readAheadBuffer == '\r') {
            this.readAheadBuffer = '\u0000';
            this.visit('\n');
        }
    }

    public final String toString() {
        return this.out.toString();
    }
}

