/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util.internal;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.internal.NormalizableStringBuilder;
import java.util.ArrayList;

public class IndentableStringBuilder
extends NormalizableStringBuilder<IndentableStringBuilder> {
    private final IndentStack indents = new IndentStack();
    private final int defaultIndent;
    private int indentLevel;
    private int quoteLevel;
    private boolean lazyAppendNewLine;
    private boolean lazyStartHangingIndent;
    private int hangingIndent;

    public IndentableStringBuilder() {
        this(-1);
    }

    public IndentableStringBuilder(int indent) {
        this.defaultIndent = indent <= 0 ? 2 : indent;
    }

    @Override
    public void clear() {
        super.clear();
        this.indents.clear();
        this.indentLevel = 0;
        this.quoteLevel = 0;
        this.lazyAppendNewLine = false;
        this.lazyStartHangingIndent = false;
        this.hangingIndent = 0;
    }

    @Override
    protected void visit(char c) {
        boolean newLine = this.endsWithNewLine();
        if (c == '\n' && this.lazyStartHangingIndent) {
            this.appendInternalNewLine();
            this.doStartHanglingIndentIfRequired();
            return;
        }
        if (!newLine && this.lazyAppendNewLine) {
            this.appendInternalNewLine();
            newLine = true;
        }
        while (this.quoteLevel < this.indentLevel) {
            String beginQuote = this.indents.getBeginQuote(this.quoteLevel);
            if (StringUtil.isEmpty(beginQuote)) {
                if (!newLine && this.indents.independent(this.quoteLevel)) {
                    this.appendInternalNewLine();
                    newLine = true;
                }
            } else {
                if (newLine) {
                    this.appendIndent(this.quoteLevel);
                } else if (!this.endsWith(" ")) {
                    this.appendInternal(" ");
                }
                this.appendInternal(beginQuote);
                this.appendInternalNewLine();
                newLine = true;
            }
            ++this.quoteLevel;
        }
        this.lazyAppendNewLine = false;
        if (c == '\n') {
            this.appendInternalNewLine();
        } else {
            if (newLine) {
                this.appendIndent(this.indentLevel);
            }
            this.appendInternal(c);
        }
    }

    public IndentableStringBuilder start() {
        return this.start(null, null, -1);
    }

    public IndentableStringBuilder start(int indent) {
        return this.start(null, null, indent);
    }

    public IndentableStringBuilder start(String beginQuote, String endQuote) {
        return this.start(beginQuote, endQuote, -1);
    }

    public IndentableStringBuilder start(String beginQuote, String endQuote, int indent) {
        this.doStartHanglingIndentIfRequired();
        this.indents.pushIndent(beginQuote, endQuote, indent);
        ++this.indentLevel;
        return this;
    }

    public IndentableStringBuilder startHangingIndent() {
        return this.startHangingIndent(0);
    }

    public IndentableStringBuilder startHangingIndent(int indentOffset) {
        this.doStartHanglingIndentIfRequired();
        this.lazyStartHangingIndent = true;
        this.hangingIndent = !this.lazyAppendNewLine && this.lineLength() - this.currentIndent() > 0 && this.quoteLevel >= this.indentLevel ? this.defaultIndent(this.lineLength() - this.currentIndent() + indentOffset) : this.defaultIndent(indentOffset);
        return this;
    }

    private void doStartHanglingIndentIfRequired() {
        if (this.lazyStartHangingIndent) {
            this.lazyStartHangingIndent = false;
            this.start("", "", this.hangingIndent);
        }
    }

    public IndentableStringBuilder end() {
        this.flush();
        if (this.lazyStartHangingIndent) {
            if (!this.endsWithNewLine()) {
                this.lazyAppendNewLine = true;
            }
            this.lazyStartHangingIndent = false;
            return this;
        }
        if (this.indentLevel > this.quoteLevel) {
            --this.indentLevel;
        } else {
            Assert.assertTrue(this.indentLevel == this.quoteLevel, "indentLevel != quoteLevel", new Object[0]);
            if (this.indentLevel > 0) {
                --this.indentLevel;
                --this.quoteLevel;
                String endQuote = this.indents.getEndQuote(this.indentLevel);
                if (!StringUtil.isEmpty(endQuote)) {
                    if (!this.endsWithNewLine()) {
                        this.appendInternalNewLine();
                    }
                    this.appendIndent(this.indentLevel);
                    this.appendInternal(endQuote);
                }
                this.lazyAppendNewLine = true;
            }
        }
        this.indents.popIndent();
        return this;
    }

    public int currentIndent() {
        return this.indents.getCurrentIndent();
    }

    private int defaultIndent(int indent) {
        return indent <= 0 ? this.defaultIndent : indent;
    }

    private void appendIndent(int indentLevel) {
        int indent = this.indents.getIndent(indentLevel - 1);
        for (int j = 0; j < indent; ++j) {
            this.appendInternal(' ');
        }
    }

    private class IndentStack
    extends ArrayList<Object> {
        private static final long serialVersionUID = -876139304840511103L;
        private static final int entrySize = 4;

        private IndentStack() {
        }

        public String getBeginQuote(int indentLevel) {
            if (indentLevel < 0 || indentLevel >= this.depth()) {
                return "";
            }
            return (String)super.get(indentLevel * 4);
        }

        public String getEndQuote(int indentLevel) {
            if (indentLevel < 0 || indentLevel >= this.depth()) {
                return "";
            }
            return (String)super.get(indentLevel * 4 + 1);
        }

        public int getIndent(int indentLevel) {
            if (indentLevel < 0 || indentLevel >= this.depth()) {
                return 0;
            }
            return (Integer)super.get(indentLevel * 4 + 2);
        }

        public boolean independent(int indentLevel) {
            int i2;
            if (indentLevel < 0 || indentLevel >= this.depth() - 1) {
                return true;
            }
            int i1 = (Integer)super.get(indentLevel * 4 + 3);
            return i1 != (i2 = ((Integer)super.get((indentLevel + 1) * 4 + 3)).intValue());
        }

        public int getCurrentIndent() {
            int depth = this.depth();
            if (depth > 0) {
                return this.getIndent(depth - 1);
            }
            return 0;
        }

        public int depth() {
            return super.size() / 4;
        }

        public void pushIndent(String beginQuote, String endQuote, int indent) {
            super.add(ObjectUtil.defaultIfNull(beginQuote, "{"));
            super.add(ObjectUtil.defaultIfNull(endQuote, "}"));
            super.add(IndentableStringBuilder.this.defaultIndent(indent) + this.getCurrentIndent());
            super.add(IndentableStringBuilder.this.length());
        }

        public void popIndent() {
            int length = super.size();
            if (length > 0) {
                for (int i = 0; i < 4; ++i) {
                    super.remove(--length);
                }
            }
        }
    }
}

