/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.util;

import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.internal.Entities;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;

public class ExceptionUtil {
    public static final Entities HTML40_COMMENT = new Entities(Entities.HTML40_MODIFIED);

    public static boolean causedBy(Throwable t, Class<? extends Throwable> causeType) {
        Assert.assertNotNull(causeType, "causeType", new Object[0]);
        HashSet causes = CollectionUtil.createHashSet();
        while (t != null && !causeType.isInstance(t) && !causes.contains(t)) {
            causes.add(t);
            t = t.getCause();
        }
        return t != null && causeType.isInstance(t);
    }

    public static Throwable getRootCause(Throwable t) {
        List<Throwable> causes = ExceptionUtil.getCauses(t, true);
        if (causes.isEmpty()) {
            return null;
        }
        return causes.get(0);
    }

    public static List<Throwable> getCauses(Throwable t) {
        return ExceptionUtil.getCauses(t, false);
    }

    public static List<Throwable> getCauses(Throwable t, boolean reversed) {
        LinkedList<Throwable> causes = CollectionUtil.createLinkedList();
        while (t != null && !causes.contains(t)) {
            if (reversed) {
                causes.addFirst(t);
            } else {
                causes.addLast(t);
            }
            t = t.getCause();
        }
        return causes;
    }

    public static RuntimeException toRuntimeException(Exception e) {
        return ExceptionUtil.toRuntimeException(e, null);
    }

    public static RuntimeException toRuntimeException(Exception e, Class<? extends RuntimeException> runtimeExceptionClass) {
        RuntimeException runtimeException;
        if (e == null) {
            return null;
        }
        if (e instanceof RuntimeException) {
            return (RuntimeException)e;
        }
        if (runtimeExceptionClass == null) {
            return new RuntimeException(e);
        }
        try {
            runtimeException = runtimeExceptionClass.newInstance();
        }
        catch (Exception ee) {
            return new RuntimeException(e);
        }
        runtimeException.initCause(e);
        return runtimeException;
    }

    public static void throwExceptionOrError(Throwable t) throws Exception {
        if (t instanceof Exception) {
            throw (Exception)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        throw new RuntimeException(t);
    }

    public static void throwRuntimeExceptionOrError(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter buffer = new StringWriter();
        PrintWriter out = new PrintWriter(buffer);
        throwable.printStackTrace(out);
        out.flush();
        return buffer.toString();
    }

    public static String getStackTraceForHtmlComment(Throwable throwable) {
        return StringEscapeUtil.escapeEntities(HTML40_COMMENT, ExceptionUtil.getStackTrace(throwable));
    }

    static {
        HTML40_COMMENT.addEntity("#45", 45);
    }
}

