/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.turbine.util;

import com.alibaba.citrus.service.pull.ToolFactory;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ClassLoaderUtil;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ServiceNotFoundException;
import com.alibaba.citrus.util.StringUtil;
import java.util.LinkedList;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.ecs.html.Input;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class CsrfToken {
    public static final String DEFAULT_TOKEN_KEY = "_csrf_token";
    public static final int DEFAULT_MAX_TOKENS = 8;
    public static final String CSRF_TOKEN_SEPARATOR = "/";
    private static final AtomicInteger counter = new AtomicInteger();
    private static final ThreadLocal<Configuration> contextTokenConfigurationHolder = new ThreadLocal();
    private final HttpServletRequest request;
    private static Logger log = LoggerFactory.getLogger(CsrfToken.class);
    private static final Generator generator = new DefaultGenerator();
    private static final Generator generatorOverride = CsrfToken.getGeneratorOverride();

    public CsrfToken(HttpServletRequest request) {
        this.request = Assert.assertNotNull(request, "request", new Object[0]);
    }

    public static String getKey() {
        String key = null;
        Configuration conf = contextTokenConfigurationHolder.get();
        if (conf != null) {
            key = conf.getTokenKey();
        }
        if (key == null) {
            key = DEFAULT_TOKEN_KEY;
        }
        return key;
    }

    public static int getMaxTokens() {
        int maxTokens = -1;
        Configuration conf = contextTokenConfigurationHolder.get();
        if (conf != null) {
            maxTokens = conf.getMaxTokens();
        }
        if (maxTokens <= 0) {
            maxTokens = 8;
        }
        return maxTokens;
    }

    public static void setContextTokenConfiguration(String tokenKey, int maxTokens) {
        contextTokenConfigurationHolder.set(new Configuration(tokenKey, maxTokens));
    }

    public static void resetContextTokenConfiguration() {
        contextTokenConfigurationHolder.remove();
    }

    public Input getHiddenField() {
        return this.getLongLiveHiddenField();
    }

    @Deprecated
    public Input getHiddenField(boolean longLiveToken) {
        return longLiveToken ? this.getLongLiveHiddenField() : this.getUniqueHiddenField();
    }

    public Input getUniqueHiddenField() {
        return new Input("hidden", CsrfToken.getKey(), this.getUniqueToken());
    }

    public Input getLongLiveHiddenField() {
        return new Input("hidden", CsrfToken.getKey(), this.getLongLiveToken());
    }

    public String getUniqueToken() {
        HttpSession session = this.request.getSession();
        String key = CsrfToken.getKey();
        String tokenOfRequest = (String)this.request.getAttribute(key);
        int maxTokens = CsrfToken.getMaxTokens();
        if (tokenOfRequest == null) {
            LinkedList<String> tokens = CsrfToken.getTokensInSession(session, key);
            tokenOfRequest = CsrfToken.getGenerator().generateUniqueToken();
            this.request.setAttribute(key, (Object)tokenOfRequest);
            tokens.addLast(tokenOfRequest);
            while (tokens.size() > maxTokens) {
                tokens.removeFirst();
            }
            CsrfToken.setTokensInSession(session, key, tokens);
        }
        return tokenOfRequest;
    }

    public String getLongLiveToken() {
        return CsrfToken.getLongLiveTokenInSession(this.request.getSession());
    }

    public static LinkedList<String> getTokensInSession(HttpSession session, String tokenKey) {
        return CollectionUtil.createLinkedList(StringUtil.split((String)session.getAttribute(tokenKey), CSRF_TOKEN_SEPARATOR));
    }

    public static void setTokensInSession(HttpSession session, String tokenKey, List<String> tokens) {
        if (tokens.isEmpty()) {
            session.removeAttribute(tokenKey);
        } else {
            session.setAttribute(tokenKey, (Object)StringUtil.join(tokens, CSRF_TOKEN_SEPARATOR));
        }
    }

    public static String getLongLiveTokenInSession(HttpSession session) {
        return CsrfToken.getGenerator().generateLongLiveToken(session);
    }

    public String toString() {
        try {
            return this.getUniqueToken();
        }
        catch (IllegalStateException e) {
            return "<No thread-bound request>";
        }
    }

    public static boolean check(HttpServletRequest request) {
        String key = CsrfToken.getKey();
        String fromRequest = StringUtil.trimToNull(request.getParameter(key));
        return fromRequest != null;
    }

    private static Generator getGeneratorOverride() {
        try {
            return (Generator)Generator.class.cast(ClassLoaderUtil.newServiceInstance("csrfTokenGeneratorOverride", CsrfToken.class));
        }
        catch (ServiceNotFoundException e) {
        }
        catch (Exception e) {
            log.warn("Failure in CsrfToken.getGeneratorOverride()", (Throwable)e);
        }
        return null;
    }

    private static Generator getGenerator() {
        return generatorOverride != null ? generatorOverride : generator;
    }

    static class DefaultGenerator
    implements Generator {
        private final long seed = new Random().nextLong();

        DefaultGenerator() {
        }

        @Override
        public String generateUniqueToken() {
            return StringUtil.longToString(counter.getAndIncrement()) + StringUtil.longToString(this.seed + System.currentTimeMillis());
        }

        @Override
        public String generateLongLiveToken(HttpSession session) {
            String sessionId = Assert.assertNotNull(session, "session", new Object[0]).getId();
            byte[] digest = DigestUtils.md5((String)(session.getCreationTime() + sessionId));
            return StringUtil.bytesToString(digest);
        }
    }

    public static interface Generator {
        public String generateUniqueToken();

        public String generateLongLiveToken(HttpSession var1);
    }

    public static class Factory
    implements ToolFactory {
        private HttpServletRequest request;

        @Autowired
        public void setRequest(HttpServletRequest request) {
            this.request = request;
        }

        @Override
        public boolean isSingleton() {
            return true;
        }

        @Override
        public Object createTool() throws Exception {
            return new CsrfToken(this.request);
        }
    }

    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<Factory> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, "tokenKey");
        }
    }

    private static class Configuration {
        private final String tokenKey;
        private final int maxTokens;

        public Configuration(String tokenKey, int maxTokens) {
            this.tokenKey = StringUtil.trimToNull(tokenKey);
            this.maxTokens = maxTokens;
        }

        public String getTokenKey() {
            return this.tokenKey;
        }

        public int getMaxTokens() {
            return this.maxTokens;
        }
    }
}

