/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support.resolver;

import com.alibaba.citrus.springext.impl.ConfigurationPointsImpl;
import com.alibaba.citrus.springext.support.resolver.ConfigurationPointNamespaceHandlerResolver;
import com.alibaba.citrus.springext.support.resolver.SchemaEntityResolver;
import com.alibaba.citrus.springext.support.resolver.SpringPluggableSchemas;
import com.alibaba.citrus.util.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParserDelegate;
import org.springframework.beans.factory.xml.DefaultBeanDefinitionDocumentReader;
import org.springframework.beans.factory.xml.DefaultNamespaceHandlerResolver;
import org.springframework.beans.factory.xml.NamespaceHandlerResolver;
import org.springframework.beans.factory.xml.ResourceEntityResolver;
import org.springframework.beans.factory.xml.XmlBeanDefinitionReader;
import org.springframework.beans.factory.xml.XmlReaderContext;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.ResourceLoader;
import org.w3c.dom.Element;
import org.xml.sax.EntityResolver;

public class XmlBeanDefinitionReaderProcessor {
    private static final String PROPERTY_SKIP_VALIDATION = "skipValidation";
    private static final Logger log = LoggerFactory.getLogger(XmlBeanDefinitionReaderProcessor.class);
    private final XmlBeanDefinitionReader reader;
    private final boolean skipValidation;

    public XmlBeanDefinitionReaderProcessor(XmlBeanDefinitionReader reader) {
        this(reader, Boolean.getBoolean(PROPERTY_SKIP_VALIDATION));
    }

    public XmlBeanDefinitionReaderProcessor(XmlBeanDefinitionReader reader, boolean skipValidation) {
        this.reader = Assert.assertNotNull(reader, "XmlBeanDefinitionReader", new Object[0]);
        this.skipValidation = skipValidation;
    }

    public void addConfigurationPointsSupport() {
        ResourceLoader resourceLoader;
        if (this.skipValidation) {
            this.reader.setValidationMode(0);
            this.reader.setNamespaceAware(true);
            this.reader.setDocumentReaderClass(DocumentReaderSkippingValidation.class);
            log.warn("XSD validation has been disabled according to the system property: -D{}.  Please be warned: NEVER skipping validation in Production Environment.", (Object)PROPERTY_SKIP_VALIDATION);
        }
        if ((resourceLoader = this.reader.getResourceLoader()) == null) {
            resourceLoader = new DefaultResourceLoader();
        }
        ClassLoader classLoader = resourceLoader.getClassLoader();
        ConfigurationPointsImpl cps = new ConfigurationPointsImpl(classLoader);
        SpringPluggableSchemas sps = new SpringPluggableSchemas(resourceLoader);
        ResourceEntityResolver defaultEntityResolver = new ResourceEntityResolver(resourceLoader);
        DefaultNamespaceHandlerResolver defaultNamespaceHanderResolver = new DefaultNamespaceHandlerResolver(classLoader);
        SchemaEntityResolver entityResolver = new SchemaEntityResolver((EntityResolver)defaultEntityResolver, cps, sps);
        ConfigurationPointNamespaceHandlerResolver namespaceHandlerResolver = new ConfigurationPointNamespaceHandlerResolver(cps, (NamespaceHandlerResolver)defaultNamespaceHanderResolver);
        this.reader.setEntityResolver((EntityResolver)entityResolver);
        this.reader.setNamespaceHandlerResolver((NamespaceHandlerResolver)namespaceHandlerResolver);
    }

    private static class BeanDefinitionParserDelegateSkippingValidation
    extends BeanDefinitionParserDelegate {
        public BeanDefinitionParserDelegateSkippingValidation(XmlReaderContext readerContext) {
            super(readerContext);
        }

        public AbstractBeanDefinition parseBeanDefinitionAttributes(Element ele, String beanName, BeanDefinition containingBean, AbstractBeanDefinition bd) {
            this.setDefaultValueForAttribute(ele, "lazy-init", "default");
            this.setDefaultValueForAttribute(ele, "autowire", "default");
            this.setDefaultValueForAttribute(ele, "dependency-check", "default");
            this.setDefaultValueForAttribute(ele, "autowire-candidate", "default");
            return super.parseBeanDefinitionAttributes(ele, beanName, containingBean, bd);
        }

        public void parseQualifierElement(Element ele, AbstractBeanDefinition bd) {
            this.setDefaultValueForAttribute(ele, "type", Qualifier.class.getName());
            super.parseQualifierElement(ele, bd);
        }

        private void setDefaultValueForAttribute(Element ele, String attrName, String defaultValue) {
            if (!ele.hasAttribute(attrName)) {
                ele.setAttribute(attrName, defaultValue);
            }
        }
    }

    public static class DocumentReaderSkippingValidation
    extends DefaultBeanDefinitionDocumentReader {
        protected BeanDefinitionParserDelegate createHelper(XmlReaderContext readerContext, Element root) {
            BeanDefinitionParserDelegateSkippingValidation delegate = new BeanDefinitionParserDelegateSkippingValidation(readerContext);
            delegate.initDefaults(root);
            return delegate;
        }
    }
}

