/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support.parser;

import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.AbstractBeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

class NamedBeanDefinitionParserMixin {
    private final DefaultNameBDParser parser;

    public NamedBeanDefinitionParserMixin(DefaultNameBDParser parser) {
        this.parser = Assert.assertNotNull(parser, "parser", new Object[0]);
    }

    String resolveId(Element element, AbstractBeanDefinition definition, ParserContext parserContext) {
        String id = StringUtil.trimToNull(element.getAttribute("id"));
        if (id == null) {
            id = Assert.assertNotNull(this.getDefaultId(), "neither id nor defaultName was specified", new Object[0]);
            id = SpringExtUtil.generateBeanName(id, parserContext.getRegistry(), (BeanDefinition)definition, parserContext.isNested());
        }
        return id;
    }

    protected void registerBeanDefinition(BeanDefinitionHolder definition, BeanDefinitionRegistry registry) {
        String[] defaultAliases;
        BeanDefinitionHolder newHolder = definition;
        if (ArrayUtil.isEmptyArray(definition.getAliases()) && !ArrayUtil.isEmptyArray(defaultAliases = this.getDefaultAliases(definition.getBeanName()))) {
            newHolder = new BeanDefinitionHolder(definition.getBeanDefinition(), definition.getBeanName(), defaultAliases);
        }
        this.parser.super_registerBeanDefinition(newHolder, registry);
    }

    private String getDefaultId() {
        String[] names = this.getDefaultNames();
        if (names.length > 0) {
            return names[0];
        }
        return null;
    }

    private String[] getDefaultAliases(String id) {
        String[] names = this.getDefaultNames();
        if (names.length > 1 && ObjectUtil.isEquals(id, names[0])) {
            String[] aliases = new String[names.length - 1];
            System.arraycopy(names, 1, aliases, 0, aliases.length);
            return aliases;
        }
        return BasicConstant.EMPTY_STRING_ARRAY;
    }

    private String[] getDefaultNames() {
        String defaultName = StringUtil.trimToNull(this.parser.internal_getDefaultName());
        String[] names = BasicConstant.EMPTY_STRING_ARRAY;
        if (defaultName != null) {
            names = defaultName.split("(,|\\s)+");
        }
        return names;
    }

    static interface DefaultNameBDParser {
        public String internal_getDefaultName();

        public void super_registerBeanDefinition(BeanDefinitionHolder var1, BeanDefinitionRegistry var2);
    }
}

