/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.support;

import org.springframework.beans.factory.BeanNameAware;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public abstract class BeanSupport
implements InitializingBean,
DisposableBean,
BeanNameAware {
    private Class<?> beanInterface;
    private String beanName;
    private boolean initialized;

    public final Class<?> getBeanInterface() {
        if (this.beanInterface == null) {
            this.beanInterface = this.resolveBeanInterface();
        }
        return this.beanInterface;
    }

    protected Class<?> resolveBeanInterface() {
        return this.getClass();
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void assertInitialized() {
        if (!this.initialized) {
            throw new IllegalStateException(String.format("Bean instance of %s has not been initialized yet.", this.getBeanInterface().getName()));
        }
    }

    protected void preInit() throws Exception {
    }

    protected void init() throws Exception {
    }

    protected void postInit() throws Exception {
    }

    public final void afterPropertiesSet() throws Exception {
        this.preInit();
        this.init();
        this.initialized = true;
        this.postInit();
    }

    protected void dispose() {
    }

    protected void preDispose() {
    }

    protected void postDispose() {
    }

    public final void destroy() {
        this.preDispose();
        this.dispose();
        this.initialized = false;
        this.postDispose();
    }

    public String getBeanName() {
        return this.beanName;
    }

    public void setBeanName(String beanName) {
        this.beanName = beanName;
    }

    public String toString() {
        return this.getBeanDescription();
    }

    protected String getBeanDescription() {
        return this.getBeanDescription(true);
    }

    protected String getBeanDescription(boolean simpleName) {
        String interfaceDesc = simpleName ? this.getBeanInterface().getSimpleName() : this.getBeanInterface().getName();
        return this.beanName == null || this.beanName.contains("(inner bean)") ? interfaceDesc : this.beanName + ":" + interfaceDesc;
    }
}

