/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.springext.impl;

import com.alibaba.citrus.springext.ConfigurationPointException;
import com.alibaba.citrus.springext.DocumentFilter;
import com.alibaba.citrus.springext.Schema;
import com.alibaba.citrus.springext.support.SchemaInternal;
import com.alibaba.citrus.springext.support.SchemaUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.io.StreamUtil;
import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import java.util.LinkedList;
import org.dom4j.Attribute;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.Namespace;
import org.dom4j.QName;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.InputStreamSource;

public class SchemaImpl
implements SchemaInternal {
    private static final Logger log = LoggerFactory.getLogger(Schema.class);
    private final String name;
    private final String version;
    private final String sourceDesc;
    private final InputStreamSource source;
    private String targetNamespace;
    private String preferredNsPrefix;
    private String[] includes;
    private String[] elements;
    private boolean parsed;
    private boolean parsingTargetNamespace;

    public SchemaImpl(String name, String version, String targetNamespace, String preferredNsPrefix, String sourceDesc, InputStreamSource source) {
        this(name, version, targetNamespace, preferredNsPrefix, false, sourceDesc, source);
    }

    public SchemaImpl(String name, String version, String sourceDesc, InputStreamSource source) {
        this(name, version, null, null, false, sourceDesc, source);
    }

    public SchemaImpl(String name, String version, boolean parsingTargetNamespace, String sourceDesc, InputStreamSource source) {
        this(name, version, null, null, parsingTargetNamespace, sourceDesc, source);
    }

    private SchemaImpl(String name, String version, String targetNamespace, String preferredNsPrefix, boolean parsingTargetNamespace, String sourceDesc, InputStreamSource source) {
        this.name = name;
        this.version = version;
        this.targetNamespace = StringUtil.trimToNull(targetNamespace);
        this.preferredNsPrefix = StringUtil.trimToNull(preferredNsPrefix);
        this.parsingTargetNamespace = parsingTargetNamespace;
        this.sourceDesc = sourceDesc;
        this.source = source;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getVersion() {
        return this.version;
    }

    @Override
    public String getTargetNamespace() {
        if (this.parsingTargetNamespace) {
            this.parse();
        }
        return this.targetNamespace;
    }

    @Override
    public String getPreferredNsPrefix() {
        return this.preferredNsPrefix;
    }

    @Override
    public String[] getIncludes() {
        this.parse();
        return this.includes == null ? BasicConstant.EMPTY_STRING_ARRAY : this.includes;
    }

    @Override
    public String[] getElements() {
        if (this.elements != null) {
            return this.elements;
        }
        this.parse();
        return this.elements == null ? BasicConstant.EMPTY_STRING_ARRAY : this.elements;
    }

    @Override
    public void setElements(String[] elements) {
        this.elements = elements;
    }

    @Override
    public String getNamespacePrefix() {
        return SchemaUtil.getNamespacePrefix(this.getPreferredNsPrefix(), this.getTargetNamespace());
    }

    @Override
    public String getSourceDescription() {
        return this.sourceDesc;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        return this.source.getInputStream();
    }

    @Override
    public Document getDocument() {
        try {
            return SchemaUtil.readDocument(this.source.getInputStream(), this.name, true);
        }
        catch (DocumentException e) {
            log.warn("Not a valid XML doc: {}, source={},\n{}", new Object[]{this.name, this.source, e.getMessage()});
            return null;
        }
        catch (IOException e) {
            throw new ConfigurationPointException("Failed to read text of schema file: " + this.name + ", source=" + this.source, e);
        }
    }

    @Override
    public String getText() throws IOException {
        return this.getText(null, null);
    }

    @Override
    public String getText(String charset) throws IOException {
        return this.getText(charset, null);
    }

    @Override
    public String getText(String charset, DocumentFilter filter) throws IOException {
        String content;
        Document doc = this.getDocument();
        if (doc == null) {
            return StreamUtil.readText(this.getInputStream(), "ISO-8859-1", true);
        }
        if (filter != null) {
            doc = Assert.assertNotNull(filter.filter(doc, this.name), "doc filter returned null", new Object[0]);
        }
        try {
            content = SchemaUtil.getDocumentText(doc, charset);
        }
        catch (IOException e) {
            throw e;
        }
        catch (Exception e) {
            throw new ConfigurationPointException("Failed to read text of schema file: " + this.name + ", source=" + this.source, e);
        }
        return content;
    }

    private void parse() {
        Attribute attr;
        if (this.parsed) {
            return;
        }
        this.parsed = true;
        Document doc = this.getDocument();
        if (doc == null) {
            return;
        }
        Element root = doc.getRootElement();
        if (!"http://www.w3.org/2001/XMLSchema".equals(root.getNamespaceURI()) || !"schema".equals(root.getName())) {
            return;
        }
        if (this.parsingTargetNamespace && (attr = root.attribute("targetNamespace")) != null) {
            this.targetNamespace = attr.getStringValue();
        }
        Namespace xsd = DocumentHelper.createNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
        QName includeName = DocumentHelper.createQName((String)"include", (Namespace)xsd);
        LinkedList<String> includeNames = CollectionUtil.createLinkedList();
        Iterator i = root.elementIterator(includeName);
        while (i.hasNext()) {
            Element includeElement = (Element)i.next();
            String schemaLocation = StringUtil.trimToNull(includeElement.attributeValue("schemaLocation"));
            if (schemaLocation == null) continue;
            includeNames.add(schemaLocation);
        }
        this.includes = includeNames.toArray(new String[includeNames.size()]);
        if (this.elements == null) {
            QName elementName = DocumentHelper.createQName((String)"element", (Namespace)xsd);
            LinkedList<String> elementNames = CollectionUtil.createLinkedList();
            Iterator i2 = root.elementIterator(elementName);
            while (i2.hasNext()) {
                Element elementElement = (Element)i2.next();
                String name = StringUtil.trimToNull(elementElement.attributeValue("name"));
                if (name == null) continue;
                elementNames.add(name);
            }
            this.elements = elementNames.toArray(new String[elementNames.size()]);
        }
    }

    public String toString() {
        if (this.targetNamespace == null) {
            return String.format("Schema[name=%s, version=%s, source=%s]", this.name, this.version, this.source);
        }
        return String.format("Schema[name=%s, version=%s, targetNamespace=%s, source=%s]", this.name, this.version, this.targetNamespace, this.source);
    }
}

