/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.velocity.impl;

import com.alibaba.citrus.service.velocity.impl.AbstractResourceLoader;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.Map;
import org.apache.commons.collections.ExtendedProperties;
import org.springframework.core.io.Resource;

public class PreloadedResourceLoader
extends AbstractResourceLoader {
    public static final String PRELOADED_RESOURCES_KEY = "resources";
    private Map<String, Resource> preloadedResources;

    public void init(ExtendedProperties configuration) {
        this.rsvc.getLog().info((Object)(this.getLogID() + " : initialization starting."));
        this.preloadedResources = CollectionUtil.createTreeMap();
        Map resources = Assert.assertNotNull((Map)configuration.getProperty(PRELOADED_RESOURCES_KEY), PRELOADED_RESOURCES_KEY, new Object[0]);
        for (Map.Entry entry : resources.entrySet()) {
            String templateName = this.normalizeTemplateName((String)entry.getKey());
            Resource resource = (Resource)entry.getValue();
            this.preloadedResources.put(templateName, resource);
        }
        this.rsvc.getLog().info((Object)(this.getLogID() + " : preloaded resources: " + new ToStringBuilder.MapBuilder().appendAll(this.preloadedResources)));
        this.rsvc.getLog().info((Object)(this.getLogID() + " : initialization complete."));
    }

    @Override
    protected String getLogID() {
        return ((Object)((Object)this)).getClass().getSimpleName();
    }

    @Override
    protected Resource getResource(String templateName) {
        return this.preloadedResources.get(this.normalizeTemplateName(templateName));
    }

    @Override
    protected String getDesc() {
        return this.preloadedResources.size() + " preloaded resources";
    }
}

