/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.uri;

import com.alibaba.citrus.service.uribroker.uri.URIBroker;

public class ContentURIBroker
extends URIBroker {
    protected static final int PREFIX_PATH_INDEX = 0;
    protected static final int CONTENT_PATH_INDEX = 1;
    private boolean hasPrefixPath;
    private boolean hasContentPath;

    public String getPrefixPath() {
        if (this.hasPrefixPath) {
            return this.getPathSegmentAsString(0);
        }
        return null;
    }

    public ContentURIBroker setPrefixPath(String prefixPath) {
        this.setPathSegment(0, prefixPath);
        this.hasPrefixPath = true;
        return this;
    }

    public String getContentPath() {
        if (this.hasContentPath) {
            return this.getPathSegmentAsString(1);
        }
        return null;
    }

    public ContentURIBroker setContentPath(String contentPath) {
        this.setPathSegment(1, contentPath);
        this.hasContentPath = true;
        return this;
    }

    public ContentURIBroker getURI(String uri) {
        return this.setContentPath(this.setUriAndGetPath(uri));
    }

    @Override
    protected URIBroker newInstance() {
        return new ContentURIBroker();
    }

    @Override
    protected void initDefaults(URIBroker parent) {
        super.initDefaults(parent);
        if (parent instanceof ContentURIBroker) {
            ContentURIBroker parentContent = (ContentURIBroker)parent;
            if (!this.hasPrefixPath) {
                this.hasPrefixPath = parentContent.hasPrefixPath;
                this.setPathSegment(0, parentContent.getPathSegment(0));
            }
            if (!this.hasContentPath) {
                this.hasContentPath = parentContent.hasContentPath;
                this.setPathSegment(1, parentContent.getPathSegment(1));
            }
        }
    }

    @Override
    protected void copyFrom(URIBroker parent) {
        super.copyFrom(parent);
        if (parent instanceof ContentURIBroker) {
            ContentURIBroker parentContent = (ContentURIBroker)parent;
            this.hasPrefixPath = parentContent.hasPrefixPath;
            this.setPathSegment(0, parentContent.getPathSegment(0));
            this.hasContentPath = parentContent.hasContentPath;
            this.setPathSegment(1, parentContent.getPathSegment(1));
        }
    }

    @Override
    protected int getPathSegmentCount() {
        return 2;
    }
}

