/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.support;

import com.alibaba.citrus.service.pull.ToolFactory;
import com.alibaba.citrus.service.pull.ToolSetFactory;
import com.alibaba.citrus.service.uribroker.URIBrokerService;
import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import java.util.Map;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;

public class URIBrokerTool
implements ToolFactory,
ToolSetFactory,
InitializingBean {
    private URIBrokerService brokers;

    @Autowired
    public void setBrokers(URIBrokerService brokers) {
        this.brokers = brokers;
    }

    public void afterPropertiesSet() throws Exception {
        Assert.assertNotNull(this.brokers, "no URIBrokerService", new Object[0]);
    }

    @Override
    public boolean isSingleton() {
        return false;
    }

    @Override
    public Iterable<String> getToolNames() {
        return this.brokers.getExposedNames();
    }

    @Override
    public Object createTool() throws Exception {
        return new Helper();
    }

    @Override
    public Object createTool(String name) throws Exception {
        return this.brokers.getURIBroker(name);
    }

    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<URIBrokerTool> {
    }

    public class Helper {
        private Map<String, URIBroker> cache = CollectionUtil.createHashMap();

        public URIBroker get(String name) {
            URIBroker broker = this.cache.get(name);
            if (broker == null) {
                broker = URIBrokerTool.this.brokers.getURIBroker(name);
                if (broker == null) {
                    return null;
                }
                this.cache.put(name, broker);
            }
            return broker;
        }
    }
}

