/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.uribroker.impl;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.uribroker.URIBrokerService;
import com.alibaba.citrus.service.uribroker.uri.URIBroker;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class URIBrokerServiceImpl
extends AbstractService<URIBrokerService>
implements URIBrokerService {
    private final HttpServletRequest request;
    private URIBrokerService[] importUris;
    private Boolean requestAware;
    private String defaultCharset;
    private URIBrokerInfo[] brokerInfos;
    private Map<String, URIBroker> brokers;
    private List<String> exposedNames;
    private List<String> names;

    public URIBrokerServiceImpl(HttpServletRequest request) {
        this.request = SpringExtUtil.assertProxy(request);
    }

    public void setImports(URIBrokerService[] importUris) {
        this.importUris = importUris;
    }

    public boolean isRequestAware() {
        return this.requestAware == null ? false : this.requestAware;
    }

    public void setRequestAware(boolean requestAware) {
        this.requestAware = requestAware;
    }

    public String getDefaultCharset() {
        return this.defaultCharset;
    }

    public void setDefaultCharset(String defaultCharset) {
        this.defaultCharset = defaultCharset;
    }

    public void setBrokers(URIBrokerInfo[] brokerInfos) {
        this.brokerInfos = brokerInfos;
    }

    @Override
    public List<String> getNames() {
        return Collections.unmodifiableList(this.names);
    }

    @Override
    public List<String> getExposedNames() {
        return Collections.unmodifiableList(this.exposedNames);
    }

    @Override
    public URIBroker getURIBroker(String name) {
        URIBroker broker = this.brokers.get(name);
        return broker == null ? null : broker.fork();
    }

    URIBroker getURIBrokerInternal(String name) {
        return this.brokers.get(name);
    }

    @Override
    protected void init() {
        Assert.assertNotNull(this.brokerInfos, "brokers", new Object[0]);
        this.brokers = CollectionUtil.createLinkedHashMap();
        this.names = CollectionUtil.createLinkedList();
        this.exposedNames = CollectionUtil.createLinkedList();
        LinkedHashMap<String, URIBrokerInfo> brokerInfoMap = CollectionUtil.createLinkedHashMap();
        for (URIBrokerInfo brokerInfo : this.brokerInfos) {
            URIBroker broker = Assert.assertNotNull(brokerInfo == null ? null : brokerInfo.broker, "broker", new Object[0]);
            brokerInfo.name = Assert.assertNotNull(StringUtil.trimToNull(brokerInfo.name), "broker ID", new Object[0]);
            brokerInfo.parentName = StringUtil.trimToNull(brokerInfo.parentName);
            Assert.assertTrue(!brokerInfoMap.containsKey(brokerInfo.name), "duplicated broker ID: %s", brokerInfo.name);
            brokerInfoMap.put(brokerInfo.name, brokerInfo);
            this.brokers.put(brokerInfo.name, broker);
            this.names.add(brokerInfo.name);
            if (brokerInfo.exposed) {
                this.exposedNames.add(brokerInfo.name);
            }
            if (this.requestAware != null && brokerInfo.parentName == null) {
                broker.setRequestAwareDefault(this.requestAware);
            }
            if (this.defaultCharset != null && brokerInfo.parentName == null && broker.getCharset() == null) {
                broker.setCharset(this.defaultCharset);
            }
            broker.setRequest(this.request);
        }
        this.brokerInfos = null;
        if (!ArrayUtil.isEmptyArray(this.importUris)) {
            for (URIBrokerService importUriBrokerService : this.importUris) {
                HashSet<String> exposedImportNames = CollectionUtil.createHashSet(importUriBrokerService.getExposedNames());
                for (String name : importUriBrokerService.getNames()) {
                    if (this.brokers.containsKey(name)) continue;
                    URIBroker uri = importUriBrokerService.getURIBroker(name);
                    uri = uri.isAutoReset() && uri.getParent() != null && !uri.getParent().isAutoReset() ? uri.getParent() : uri.fork(false);
                    this.brokers.put(name, uri);
                    this.names.add(name);
                    if (!exposedImportNames.contains(name)) continue;
                    this.exposedNames.add(name);
                }
            }
        }
        for (Map.Entry entry : brokerInfoMap.entrySet()) {
            URIBrokerInfo brokerInfo;
            String name = (String)entry.getKey();
            brokerInfo = (URIBrokerInfo)entry.getValue();
            String parentName = brokerInfo.parentName;
            this.checkCyclic(brokerInfoMap, name, parentName);
            if (parentName == null) continue;
            URIBroker parentBroker = Assert.assertNotNull(this.brokers.get(parentName), "parent \"%s\" not found for broker \"%s\"", parentName, brokerInfo.name);
            URIBroker thisBroker = brokerInfo.broker;
            thisBroker.setParent(parentBroker);
        }
        for (URIBroker broker : this.brokers.values()) {
            broker.init();
        }
    }

    private String checkCyclic(Map<String, URIBrokerInfo> brokerInfoMap, String name, String parentName) {
        LinkedHashSet<String> inheritanceChain = CollectionUtil.createLinkedHashSet(name);
        while (parentName != null) {
            if (inheritanceChain.contains(parentName)) {
                StringBuilder buf = new StringBuilder();
                buf.append("Cyclic detected: ");
                for (String item : inheritanceChain) {
                    buf.append(item).append("->");
                }
                buf.append(parentName);
                throw new IllegalArgumentException(buf.toString());
            }
            inheritanceChain.add(parentName);
            parentName = brokerInfoMap.containsKey(parentName) ? brokerInfoMap.get((Object)parentName).parentName : null;
        }
        return parentName;
    }

    @Override
    public String dump() {
        StringWriter buf = new StringWriter();
        this.dump(buf);
        return buf.toString();
    }

    @Override
    public void dump(Writer writer) {
        URIBroker broker;
        String name;
        PrintWriter out = null;
        out = writer instanceof PrintWriter ? (PrintWriter)writer : new PrintWriter(writer);
        int classWidth = 0;
        int keyWidth = 0;
        for (Map.Entry<String, URIBroker> entry : this.brokers.entrySet()) {
            name = entry.getKey();
            broker = entry.getValue();
            String className = broker.getClass().getSimpleName();
            if (className.length() > classWidth) {
                classWidth = className.length();
            }
            if (name.length() <= keyWidth) continue;
            keyWidth = name.length();
        }
        for (Map.Entry<String, URIBroker> entry : this.brokers.entrySet()) {
            name = entry.getKey();
            broker = entry.getValue();
            broker = broker.fork();
            StringBuilder format = new StringBuilder();
            if (this.exposedNames.contains(name)) {
                format.append("* ");
            } else {
                format.append("  ");
            }
            format.append("%-").append(classWidth + 2).append("s %-").append(keyWidth).append("s= %s%n");
            out.printf(format.toString(), "(" + broker.getClass().getSimpleName() + ")", name, broker);
        }
        out.flush();
    }

    public static class URIBrokerInfo {
        public String name;
        public String parentName;
        public boolean exposed;
        public URIBroker broker;

        public URIBrokerInfo(String name, String parentName, Boolean exposed, URIBroker broker) {
            this.name = StringUtil.trimToNull(name);
            this.parentName = StringUtil.trimToNull(parentName);
            this.exposed = exposed == null ? false : exposed;
            this.broker = broker;
        }
    }
}

