/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.resource.loader;

import com.alibaba.citrus.service.resource.Resource;
import com.alibaba.citrus.service.resource.ResourceLoader;
import com.alibaba.citrus.service.resource.ResourceLoaderContext;
import com.alibaba.citrus.service.resource.ResourceLoadingOption;
import com.alibaba.citrus.service.resource.ResourceLoadingService;
import com.alibaba.citrus.service.resource.support.URLResource;
import java.net.URL;
import java.util.Set;
import org.springframework.context.ResourceLoaderAware;

public class ClasspathResourceLoader
implements ResourceLoader,
ResourceLoaderAware {
    private ClassLoader cl;

    public ClassLoader getClassLoader() {
        return this.cl;
    }

    public void setClassLoader(ClassLoader cl) {
        this.cl = cl;
    }

    public void setResourceLoader(org.springframework.core.io.ResourceLoader springLoader) {
        this.cl = springLoader.getClassLoader();
    }

    @Override
    public void init(ResourceLoadingService resourceLoadingService) {
        if (this.cl == null) {
            this.cl = this.getClass().getClassLoader();
        }
    }

    @Override
    public Resource getResource(ResourceLoaderContext context, Set<ResourceLoadingOption> options) {
        URL resourceURL;
        String resourceName = context.substitute("");
        if (resourceName.startsWith("/")) {
            resourceName = resourceName.substring(1);
        }
        if ((resourceURL = this.cl.getResource(resourceName)) != null) {
            return new URLResource(resourceURL);
        }
        return null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.cl + "]";
    }
}

