/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.util;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import javax.servlet.http.HttpServletRequest;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

public class RequestContextUtil {
    private static final String REQUEST_CONTEXT_KEY = "_outer_webx3_request_context_";

    public static RequestContext getRequestContext(HttpServletRequest request) {
        return (RequestContext)request.getAttribute(REQUEST_CONTEXT_KEY);
    }

    public static void setRequestContext(RequestContext requestContext) {
        HttpServletRequest request = requestContext.getRequest();
        request.setAttribute(REQUEST_CONTEXT_KEY, (Object)requestContext);
    }

    public static void removeRequestContext(HttpServletRequest request) {
        request.removeAttribute(REQUEST_CONTEXT_KEY);
    }

    public static <R extends RequestContext> R findRequestContext(HttpServletRequest request, Class<R> requestContextInterface) {
        return RequestContextUtil.findRequestContext(RequestContextUtil.getRequestContext(request), requestContextInterface);
    }

    public static <R extends RequestContext> R findRequestContext(RequestContext requestContext, Class<R> requestContextInterface) {
        while (!requestContextInterface.isInstance(requestContext) && (requestContext = requestContext.getWrappedRequestContext()) != null) {
        }
        return (R)((RequestContext)requestContextInterface.cast(requestContext));
    }

    public static void registerRequestDestructionCallback(String name, Runnable callback) {
        ServletRequestAttributes attributes = (ServletRequestAttributes)RequestContextHolder.getRequestAttributes();
        attributes.registerDestructionCallback(name, callback, 0);
    }
}

