/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.util;

import com.alibaba.citrus.service.requestcontext.util.tomcat.ServerCookie;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.BasicConstant;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletResponse;
import net.sf.cglib.reflect.FastClass;
import net.sf.cglib.reflect.FastMethod;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CookieSupport
extends Cookie {
    private static final Logger log = LoggerFactory.getLogger(CookieSupport.class);
    private static final FastMethod getHttpOnlyMethod = CookieSupport.getHttpOnlyMethod();
    private boolean httpOnly;

    public CookieSupport(String name, String value) {
        super(Assert.assertNotNull(StringUtil.trimToNull(name), "cookieName", new Object[0]), value);
    }

    public CookieSupport(Cookie cookie) {
        this(cookie, null);
    }

    public CookieSupport(Cookie cookie, String name) {
        super(Assert.assertNotNull(CookieSupport.getCookieName(cookie, name), "cookieName", new Object[0]), cookie.getValue());
        String path;
        String domain;
        this.setVersion(cookie.getVersion());
        this.setMaxAge(cookie.getMaxAge());
        this.setSecure(cookie.getSecure());
        String comment = cookie.getComment();
        if (!StringUtil.isEmpty(comment)) {
            this.setComment(comment);
        }
        if (!StringUtil.isEmpty(domain = cookie.getDomain())) {
            this.setDomain(domain);
        }
        if (!StringUtil.isEmpty(path = cookie.getPath())) {
            this.setPath(path);
        }
        if (cookie instanceof CookieSupport) {
            this.setHttpOnly(((CookieSupport)cookie).getHttpOnly());
        } else if (getHttpOnlyMethod != null) {
            try {
                this.setHttpOnly((Boolean)getHttpOnlyMethod.invoke((Object)cookie, BasicConstant.EMPTY_OBJECT_ARRAY));
            }
            catch (InvocationTargetException e) {
                log.warn("Invocation of Cookie.isHttpOnly() failed", e.getTargetException());
            }
        }
    }

    private static FastMethod getHttpOnlyMethod() {
        Method m = null;
        try {
            m = Cookie.class.getMethod("isHttpOnly", new Class[0]);
        }
        catch (Exception e) {
            try {
                m = Cookie.class.getMethod("getHttpOnly", new Class[0]);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (m != null) {
            log.debug("Method Cookie.isHttpOnly() defined in current version of servlet api.  CookieSupport will make use of it.");
            return FastClass.create((ClassLoader)CookieSupport.class.getClassLoader(), Cookie.class).getMethod(m);
        }
        log.debug("No method Cookie.isHttpOnly() defined in current version of servlet api.");
        return null;
    }

    private static String getCookieName(Cookie cookie, String name) {
        if ((name = StringUtil.trimToNull(name)) == null) {
            name = StringUtil.trimToNull(cookie.getName());
        }
        return name;
    }

    public boolean isHttpOnly() {
        return this.httpOnly;
    }

    public boolean getHttpOnly() {
        return this.httpOnly;
    }

    public void setHttpOnly(boolean httpOnly) {
        this.httpOnly = httpOnly;
    }

    public void setDomain(String domain) {
        if (!StringUtil.isEmpty(domain = StringUtil.trimToEmpty(domain)) && !domain.startsWith(".")) {
            domain = "." + domain;
        }
        super.setDomain(domain);
    }

    public void addCookie(HttpServletResponse response) {
        response.addHeader(this.getCookieHeaderName(), this.getCookieHeaderValue());
    }

    public String getCookieHeaderName() {
        return ServerCookie.getCookieHeaderName(this.getVersion());
    }

    public String getCookieHeaderValue() throws IllegalArgumentException {
        return this.appendCookieHeaderValue(new StringBuilder()).toString();
    }

    private StringBuilder appendCookieHeaderValue(StringBuilder buf) throws IllegalArgumentException {
        int version = this.getVersion();
        String name = ObjectUtil.defaultIfNull(this.getName(), "");
        String value = this.getValue();
        String path = this.getPath();
        String domain = StringUtil.trimToNull(this.getDomain());
        String comment = StringUtil.trimToNull(this.getComment());
        int maxAge = StringUtil.isEmpty(this.getValue()) ? 0 : this.getMaxAge();
        boolean secure = this.getSecure();
        boolean httpOnly = this.getHttpOnly();
        ServerCookie.appendCookieValue(buf, version, name, value, path, domain, comment, maxAge, secure, httpOnly);
        return buf;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder().append(this.getCookieHeaderName()).append(": ");
        int length = buf.length();
        try {
            this.appendCookieHeaderValue(buf);
        }
        catch (IllegalArgumentException e) {
            buf.setLength(length);
            buf.append(e.getMessage());
        }
        return buf.toString();
    }
}

