/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.session.interceptor;

import com.alibaba.citrus.logconfig.support.ConfigurableLogger;
import com.alibaba.citrus.logconfig.support.SecurityLogger;
import com.alibaba.citrus.service.requestcontext.session.SessionConfig;
import com.alibaba.citrus.service.requestcontext.session.SessionLifecycleListener;
import com.alibaba.citrus.springext.support.parser.AbstractSingleBeanDefinitionParser;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import javax.servlet.http.HttpSession;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class SessionLifecycleLogger
implements SessionLifecycleListener {
    private static final ConfigurableLogger.Level DEFAULT_LOG_LEVEL = ConfigurableLogger.Level.debug;
    private static final ConfigurableLogger.Level DEFAULT_VISITED_LOG_LEVEL = ConfigurableLogger.Level.trace;
    private final SecurityLogger log = new SecurityLogger();
    private ConfigurableLogger.Level logLevel;
    private ConfigurableLogger.Level visitLogLevel;

    public void setLogName(String name) {
        this.log.setLogName(name);
    }

    public void setLogLevel(ConfigurableLogger.Level level) {
        this.logLevel = level;
    }

    public void setVisitLogLevel(ConfigurableLogger.Level level) {
        this.visitLogLevel = level;
    }

    @Override
    public void init(SessionConfig sessionConfig) {
        if (this.logLevel == null) {
            this.logLevel = DEFAULT_LOG_LEVEL;
        }
        if (this.visitLogLevel == null) {
            this.visitLogLevel = DEFAULT_VISITED_LOG_LEVEL;
        }
    }

    @Override
    public void sessionCreated(HttpSession session) {
        if (this.log.isLevelEnabled(this.logLevel)) {
            this.log.log(this.logLevel, "session created, id=" + session.getId());
        }
    }

    @Override
    public void sessionInvalidated(HttpSession session) {
        if (this.log.isLevelEnabled(this.logLevel)) {
            this.log.log(this.logLevel, "session invalidated, id=" + session.getId());
        }
    }

    @Override
    public void sessionVisited(HttpSession session) {
        if (this.log.isLevelEnabled(this.visitLogLevel)) {
            this.log.log(this.visitLogLevel, "session visited, id=" + session.getId());
        }
    }

    public static class DefinitionParser
    extends AbstractSingleBeanDefinitionParser<SessionLifecycleLogger> {
        protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            SpringExtUtil.attributesToProperties(element, builder, new String[0]);
        }
    }
}

