/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.rundata.impl;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.buffered.BufferedRequestContext;
import com.alibaba.citrus.service.requestcontext.lazycommit.LazyCommitRequestContext;
import com.alibaba.citrus.service.requestcontext.locale.SetLocaleRequestContext;
import com.alibaba.citrus.service.requestcontext.parser.CookieParser;
import com.alibaba.citrus.service.requestcontext.parser.ParameterParser;
import com.alibaba.citrus.service.requestcontext.parser.ParserRequestContext;
import com.alibaba.citrus.service.requestcontext.rundata.RunData;
import com.alibaba.citrus.service.requestcontext.rundata.User;
import com.alibaba.citrus.service.requestcontext.support.AbstractRequestContextWrapper;
import com.alibaba.citrus.service.requestcontext.util.RequestContextUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.io.ByteArray;
import java.io.IOException;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RunDataImpl
extends AbstractRequestContextWrapper
implements RunData {
    private static final Logger log = LoggerFactory.getLogger(RunData.class);
    private final BufferedRequestContext bufferedRequestContext;
    private final LazyCommitRequestContext lazyCommitRequestContext;
    private final SetLocaleRequestContext setLocaleRequestContext;
    private final ParserRequestContext parserRequestContext;
    private User user;

    public RunDataImpl(RequestContext wrappedContext) {
        super(wrappedContext);
        this.bufferedRequestContext = RequestContextUtil.findRequestContext(wrappedContext, BufferedRequestContext.class);
        this.lazyCommitRequestContext = RequestContextUtil.findRequestContext(wrappedContext, LazyCommitRequestContext.class);
        this.setLocaleRequestContext = RequestContextUtil.findRequestContext(wrappedContext, SetLocaleRequestContext.class);
        this.parserRequestContext = RequestContextUtil.findRequestContext(wrappedContext, ParserRequestContext.class);
        if (this.bufferedRequestContext == null) {
            log.debug("RunData feature BufferedRequestContext disabled");
        }
        if (this.lazyCommitRequestContext == null) {
            log.debug("RunData feature LazyCommitRequestContext disabled");
        }
        if (this.setLocaleRequestContext == null) {
            log.debug("RunData feature SetLocaleRequestContext disabled");
        }
        if (this.parserRequestContext == null) {
            log.debug("RunData feature ParserRequestContext disabled");
        }
    }

    protected BufferedRequestContext getBufferedRequestContext() {
        return Assert.assertNotNull(this.bufferedRequestContext, "Could not find BufferedRequestContext in request context chain", new Object[0]);
    }

    protected LazyCommitRequestContext getLazyCommitRequestContext() {
        return Assert.assertNotNull(this.lazyCommitRequestContext, "Could not find LazyCommitRequestContext in request context chain", new Object[0]);
    }

    protected SetLocaleRequestContext getSetLocaleRequestContext() {
        return Assert.assertNotNull(this.setLocaleRequestContext, "Could not find SetLocaleRequestContext in request context chain", new Object[0]);
    }

    protected ParserRequestContext getParserRequestContext() {
        return Assert.assertNotNull(this.parserRequestContext, "Could not find ParserRequestContext in request context chain", new Object[0]);
    }

    @Override
    public ParameterParser getParameters() {
        return this.getParserRequestContext().getParameters();
    }

    @Override
    public CookieParser getCookies() {
        return this.getParserRequestContext().getCookies();
    }

    @Override
    public HttpSession getSession() {
        return this.getRequest().getSession();
    }

    @Override
    public String getContextPath() {
        return this.getRequest().getContextPath();
    }

    @Override
    public String getServletPath() {
        return this.getRequest().getServletPath();
    }

    @Override
    public String getPathInfo() {
        return this.getRequest().getPathInfo();
    }

    @Override
    public String getRequestURL() {
        return this.getRequestURL(true);
    }

    @Override
    public String getRequestURL(boolean withQueryString) {
        String queryString;
        StringBuffer buffer = this.getRequest().getRequestURL();
        if (withQueryString && (queryString = StringUtil.trimToNull(this.getRequest().getQueryString())) != null) {
            buffer.append('?').append(queryString);
        }
        return buffer.toString();
    }

    @Override
    public boolean isPostRequest() {
        return "post".equalsIgnoreCase(this.getRequest().getMethod());
    }

    @Override
    public User getUser() {
        return this.user;
    }

    @Override
    public void setUser(User user) {
        this.user = user;
    }

    @Override
    public Object getAttribute(String key) {
        return this.getRequest().getAttribute(key);
    }

    @Override
    public void setAttribute(String key, Object object) {
        if (object == null) {
            this.getRequest().removeAttribute(key);
        } else {
            this.getRequest().setAttribute(key, object);
        }
    }

    @Override
    public String getContentType() {
        return this.getSetLocaleRequestContext().getResponseContentType();
    }

    @Override
    public void setContentType(String contentType) {
        this.getResponse().setContentType(contentType);
    }

    @Override
    public void setContentType(String contentType, boolean appendCharset) {
        this.getSetLocaleRequestContext().setResponseContentType(contentType, appendCharset);
    }

    @Override
    public String getCharacterEncoding() {
        return this.getResponse().getCharacterEncoding();
    }

    @Override
    public void setCharacterEncoding(String charset) {
        this.getSetLocaleRequestContext().setResponseCharacterEncoding(charset);
    }

    @Override
    public String getRedirectLocation() {
        return this.getLazyCommitRequestContext().getRedirectLocation();
    }

    @Override
    public void setRedirectLocation(String location) throws IOException {
        this.getResponse().sendRedirect(location);
    }

    @Override
    public boolean isRedirected() {
        return this.getLazyCommitRequestContext().isRedirected();
    }

    @Override
    public int getStatusCode() {
        return this.getLazyCommitRequestContext().getStatus();
    }

    @Override
    public void setStatusCode(int status) {
        this.getResponse().setStatus(status);
    }

    @Override
    public boolean isBuffering() {
        return this.getBufferedRequestContext().isBuffering();
    }

    @Override
    public void setBuffering(boolean buffering) {
        this.getBufferedRequestContext().setBuffering(buffering);
    }

    @Override
    public void pushBuffer() {
        this.getBufferedRequestContext().pushBuffer();
    }

    @Override
    public ByteArray popByteBuffer() {
        return this.getBufferedRequestContext().popByteBuffer();
    }

    @Override
    public String popCharBuffer() {
        return this.getBufferedRequestContext().popCharBuffer();
    }

    @Override
    public void resetBuffer() {
        this.getResponse().resetBuffer();
    }

    @Override
    public String convertCase(String str) {
        return this.getParserRequestContext().convertCase(str);
    }
}

