/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.rewrite.impl;

import com.alibaba.citrus.service.requestcontext.RequestContext;
import com.alibaba.citrus.service.requestcontext.parser.ParameterParser;
import com.alibaba.citrus.service.requestcontext.parser.ParserRequestContext;
import com.alibaba.citrus.service.requestcontext.rewrite.RewriteRequestContext;
import com.alibaba.citrus.service.requestcontext.rewrite.RewriteSubstitutionContext;
import com.alibaba.citrus.service.requestcontext.rewrite.RewriteSubstitutionHandler;
import com.alibaba.citrus.service.requestcontext.rewrite.impl.RewriteRule;
import com.alibaba.citrus.service.requestcontext.rewrite.impl.RewriteSubstitution;
import com.alibaba.citrus.service.requestcontext.rewrite.impl.RewriteUtil;
import com.alibaba.citrus.service.requestcontext.support.AbstractRequestContextWrapper;
import com.alibaba.citrus.service.requestcontext.support.AbstractRequestWrapper;
import com.alibaba.citrus.service.requestcontext.util.RequestContextUtil;
import com.alibaba.citrus.util.ArrayUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.FileUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.ServletUtil;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.regex.MatchResultSubstitution;
import java.io.IOException;
import java.util.regex.MatchResult;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RewriteRequestContextImpl
extends AbstractRequestContextWrapper
implements RewriteRequestContext {
    private static final Logger log = LoggerFactory.getLogger(RewriteRequestContext.class);
    public static final String SERVER_SCHEME_HTTP = "http";
    public static final String SERVER_SCHEME_HTTPS = "https";
    public static final int SERVER_PORT_HTTP = 80;
    public static final int SERVER_PORT_HTTPS = 443;
    private final RewriteRule[] rules;
    private ParserRequestContext parserRequestContext;
    private HttpServletRequest wrappedRequest;

    public RewriteRequestContextImpl(RequestContext wrappedContext, RewriteRule[] rules) {
        super(wrappedContext);
        this.rules = ArrayUtil.defaultIfEmptyArray(rules, null);
        this.parserRequestContext = Assert.assertNotNull(RequestContextUtil.findRequestContext(wrappedContext, ParserRequestContext.class), "Could not find ParserRequestContext in request context chain", new Object[0]);
        this.wrappedRequest = wrappedContext.getRequest();
    }

    @Override
    public void prepare() {
        block17: {
            String originalPath;
            if (this.rules == null) {
                return;
            }
            String path = originalPath = this.wrappedRequest.getServletPath() + ObjectUtil.defaultIfNull(this.wrappedRequest.getPathInfo(), "");
            boolean parameterSubstituted = false;
            if (log.isDebugEnabled()) {
                log.debug("Starting rewrite engine: path=\"{}\"", (Object)StringEscapeUtil.escapeJava(path));
            }
            int redirectCode = 0;
            for (RewriteRule rule : this.rules) {
                MatchResult ruleMatchResult = rule.match(path);
                MatchResult conditionMatchResult = null;
                RewriteSubstitution subs = rule.getSubstitution();
                if (ruleMatchResult != null) {
                    conditionMatchResult = rule.matchConditions(ruleMatchResult, this.wrappedRequest);
                }
                boolean chainRule = subs.getFlags().hasC();
                if (conditionMatchResult == null) {
                    if (!chainRule) continue;
                    break;
                }
                MatchResultSubstitution resultSubs = RewriteUtil.getMatchResultSubstitution(ruleMatchResult, conditionMatchResult);
                log.debug("Rule conditions have been satisfied, starting substitution to uri");
                path = subs.substitute(path, resultSubs);
                if (!RewriteUtil.isFullURL(path)) {
                    path = FileUtil.normalizeAbsolutePath(path);
                }
                parameterSubstituted |= subs.substituteParameters(this.parserRequestContext.getParameters(), resultSubs);
                path = this.firePostSubstitutionEvent(rule, path, this.parserRequestContext, resultSubs);
                redirectCode = subs.getFlags().getRedirectCode();
                boolean lastRule = subs.getFlags().hasL();
                if (lastRule) break;
            }
            if (!ObjectUtil.isEquals(originalPath, path)) {
                if (redirectCode > 0) {
                    StringBuffer uri = new StringBuffer();
                    HttpServletRequest request = this.getRequest();
                    if (!RewriteUtil.isFullURL(path)) {
                        uri.append(request.getScheme()).append("://").append(request.getServerName());
                        boolean isDefaultPort = false;
                        isDefaultPort |= SERVER_SCHEME_HTTP.equals(request.getScheme()) && request.getServerPort() == 80;
                        if (!(isDefaultPort |= SERVER_SCHEME_HTTPS.equals(request.getScheme()) && request.getServerPort() == 443)) {
                            uri.append(":");
                            uri.append(request.getServerPort());
                        }
                        uri.append(request.getContextPath());
                    }
                    uri.append(path);
                    String queryString = this.parserRequestContext.getParameters().toQueryString();
                    if (!StringUtil.isEmpty(queryString)) {
                        uri.append("?").append(queryString);
                    }
                    String uriLocation = uri.toString();
                    try {
                        if (redirectCode == 302) {
                            this.getResponse().sendRedirect(uriLocation);
                            break block17;
                        }
                        this.getResponse().setHeader("Location", uriLocation);
                        this.getResponse().setStatus(redirectCode);
                    }
                    catch (IOException e) {
                        log.warn("Redirect to location \"" + uriLocation + "\" failed", (Throwable)e);
                    }
                } else {
                    RequestWrapper requestWrapper = new RequestWrapper(this.wrappedRequest);
                    requestWrapper.setPath(path);
                    this.setRequest((HttpServletRequest)requestWrapper);
                }
            } else if (!parameterSubstituted) {
                log.trace("No rewrite substitution happend!");
            }
        }
    }

    private String firePostSubstitutionEvent(RewriteRule rule, String path, ParserRequestContext parser, MatchResultSubstitution resultSubs) {
        for (Object handler : rule.handlers()) {
            RewriteSubstitutionContextImpl context = null;
            if (!(handler instanceof RewriteSubstitutionHandler)) continue;
            if (context == null) {
                context = new RewriteSubstitutionContextImpl(path, parser, resultSubs);
            }
            if (log.isTraceEnabled()) {
                log.trace("Processing post-substitution event for \"{}\" with handler: {}", (Object)StringEscapeUtil.escapeJava(path), handler);
            }
            ((RewriteSubstitutionHandler)handler).postSubstitution(context);
            String newPath = context.getPath();
            if (newPath != null && !ObjectUtil.isEquals(path, newPath) && log.isDebugEnabled()) {
                log.debug("Rewriting \"{}\" to \"{}\"", (Object)StringEscapeUtil.escapeJava(path), (Object)StringEscapeUtil.escapeJava(newPath));
            }
            path = newPath;
        }
        return path;
    }

    private class RequestWrapper
    extends AbstractRequestWrapper {
        private String path;
        private final boolean prefixMapping;
        private final String originalServletPath;

        public RequestWrapper(HttpServletRequest request) {
            super(RewriteRequestContextImpl.this, request);
            this.prefixMapping = ServletUtil.isPrefixServletMapping(request);
            this.originalServletPath = request.getServletPath();
        }

        public void setPath(String path) {
            this.path = StringUtil.trimToNull(path);
        }

        public String getServletPath() {
            if (this.path == null) {
                return super.getServletPath();
            }
            if (this.prefixMapping) {
                if (ServletUtil.startsWithPath(this.originalServletPath, this.path)) {
                    return this.originalServletPath;
                }
                return "";
            }
            return this.path;
        }

        public String getPathInfo() {
            if (this.path == null) {
                return super.getPathInfo();
            }
            if (this.prefixMapping) {
                if (ServletUtil.startsWithPath(this.originalServletPath, this.path)) {
                    return this.path.substring(this.originalServletPath.length());
                }
                return this.path;
            }
            return null;
        }
    }

    private class RewriteSubstitutionContextImpl
    implements RewriteSubstitutionContext {
        private String path;
        private ParserRequestContext parser;
        private MatchResultSubstitution resultSubs;

        public RewriteSubstitutionContextImpl(String path, ParserRequestContext parser, MatchResultSubstitution resultSubs) {
            this.path = path;
            this.parser = parser;
            this.resultSubs = resultSubs;
        }

        @Override
        public String getPath() {
            return this.path;
        }

        @Override
        public void setPath(String path) {
            this.path = path;
        }

        @Override
        public ParserRequestContext getParserRequestContext() {
            return this.parser;
        }

        @Override
        public ParameterParser getParameters() {
            return this.parser.getParameters();
        }

        @Override
        public MatchResultSubstitution getMatchResultSubstitution() {
            return this.resultSubs;
        }
    }
}

