/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.requestcontext.rewrite.impl;

import com.alibaba.citrus.service.requestcontext.rewrite.impl.Flags;
import com.alibaba.citrus.service.requestcontext.rewrite.impl.RewriteUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.StringEscapeUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import com.alibaba.citrus.util.regex.MatchResultSubstitution;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class RewriteCondition
implements InitializingBean {
    private static final Logger log = LoggerFactory.getLogger(RewriteCondition.class);
    private String testString;
    private String patternString;
    private Pattern pattern;
    private boolean negative;
    private ConditionFlags flags;

    public void setTest(String testString) {
        this.testString = StringUtil.trimToNull(testString);
    }

    public void setPattern(String patternString) throws PatternSyntaxException {
        this.patternString = StringUtil.trimToNull(patternString);
    }

    public void setFlags(String[] flags) {
        this.flags = new ConditionFlags(flags);
    }

    public ConditionFlags getFlags() {
        return this.flags;
    }

    public void afterPropertiesSet() throws Exception {
        String realPattern;
        Assert.assertNotNull(this.testString, "missing test attribute for condition", new Object[0]);
        if (this.patternString == null || "!".equals(this.patternString)) {
            throw new PatternSyntaxException("empty pattern", this.patternString, -1);
        }
        if (this.patternString.startsWith("!")) {
            this.negative = true;
            realPattern = this.patternString.substring(1);
        } else {
            realPattern = this.patternString;
        }
        this.pattern = Pattern.compile(realPattern);
        if (this.flags == null) {
            this.flags = new ConditionFlags();
        }
    }

    public MatchResult match(MatchResult ruleMatchResult, MatchResult conditionMatchResult, HttpServletRequest request) {
        if (log.isTraceEnabled()) {
            log.trace("Testing condition: testString=\"{}\", pattern=\"{}\"", (Object)StringEscapeUtil.escapeJava(this.testString), (Object)StringEscapeUtil.escapeJava(this.patternString));
        }
        String subsTestString = RewriteUtil.getSubstitutedTestString(this.testString, ruleMatchResult, conditionMatchResult, request);
        if (log.isTraceEnabled()) {
            log.trace("Expanded testString: original=\"{}\", expanded=\"{}\"", (Object)StringEscapeUtil.escapeJava(this.testString), (Object)StringEscapeUtil.escapeJava(subsTestString));
        }
        Matcher matcher = this.pattern.matcher(subsTestString);
        boolean matched = matcher.find();
        if (!this.negative && matched) {
            if (log.isDebugEnabled()) {
                log.debug("Testing \"{}\" with condition pattern: \"{}\", MATCHED", (Object)StringEscapeUtil.escapeJava(subsTestString), (Object)StringEscapeUtil.escapeJava(this.patternString));
            }
            return matcher.toMatchResult();
        }
        if (this.negative && !matched) {
            if (log.isDebugEnabled()) {
                log.debug("Testing \"{}\" with condition pattern: \"{}\", MATCHED", (Object)StringEscapeUtil.escapeJava(subsTestString), (Object)StringEscapeUtil.escapeJava(this.patternString));
            }
            return MatchResultSubstitution.EMPTY_MATCH_RESULT;
        }
        if (log.isTraceEnabled()) {
            log.trace("Testing \"{}\" with condition pattern: \"{}\", MISMATCHED", (Object)StringEscapeUtil.escapeJava(subsTestString), (Object)StringEscapeUtil.escapeJava(this.patternString));
        }
        return null;
    }

    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("test", this.testString);
        mb.append("pattern", this.patternString);
        if (!this.flags.isEmpty()) {
            mb.append("flags", this.flags);
        }
        return new ToStringBuilder().append("Condition").append(mb).toString();
    }

    public static class ConditionFlags
    extends Flags {
        public ConditionFlags() {
        }

        public ConditionFlags(String ... flags) {
            super(flags);
        }

        public boolean hasOR() {
            return this.hasFlags("OR", "ornext");
        }
    }
}

