/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pull.support;

import com.alibaba.citrus.service.pull.ToolFactory;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.HashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConstantTool
implements ToolFactory {
    private static final Logger log = LoggerFactory.getLogger(ConstantTool.class);
    private Class<?> constantClass;
    protected Map<String, Object> constants = CollectionUtil.createHashMap();

    public Class<?> getConstantClass() {
        return this.constantClass;
    }

    public void setConstantClass(Class<?> constantClass) {
        this.constantClass = Assert.assertNotNull(constantClass, "constantClass", new Object[0]);
        log.trace("Introspecting constants in class {}", (Object)constantClass.getName());
        Field[] fields = constantClass.getFields();
        HashMap<String, Field> fieldsMap = CollectionUtil.createHashMap();
        for (Field field : fields) {
            int modifier = field.getModifiers();
            if (!Modifier.isPublic(modifier) || !Modifier.isFinal(modifier) || !Modifier.isStatic(modifier)) continue;
            if (fieldsMap.containsKey(field.getName())) {
                Field existField = (Field)fieldsMap.get(field.getName());
                if (!existField.getDeclaringClass().isAssignableFrom(field.getDeclaringClass())) continue;
                fieldsMap.put(field.getName(), field);
                continue;
            }
            fieldsMap.put(field.getName(), field);
        }
        for (Field field : fieldsMap.values()) {
            try {
                Object value = field.get(null);
                this.constants.put(field.getName(), field.get(null));
                if (!log.isTraceEnabled()) continue;
                log.trace("Found constant: {}.{} = {}", new Object[]{constantClass.getSimpleName(), field.getName(), ObjectUtil.toString(value)});
            }
            catch (Exception e) {
                Assert.unexpectedException(e, "failed to get constant: %s", field.getName());
            }
        }
    }

    @Override
    public boolean isSingleton() {
        return true;
    }

    @Override
    public Object createTool() {
        return this;
    }

    public Object get(String name) {
        return this.constants.get(name);
    }

    public String toString() {
        return new ToStringBuilder().append("Constant[").append(this.constantClass == null ? "" : this.constantClass.getSimpleName()).append("]").append(this.constants).toString();
    }
}

