/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.pipeline.impl.valve;

import com.alibaba.citrus.service.pipeline.Condition;
import com.alibaba.citrus.service.pipeline.Pipeline;
import com.alibaba.citrus.service.pipeline.PipelineContext;
import com.alibaba.citrus.service.pipeline.support.AbstractValve;
import com.alibaba.citrus.service.pipeline.support.AbstractValveDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.List;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ChooseValve
extends AbstractValve {
    private Condition[] whenConditions;
    private Pipeline[] whenBlocks;
    private Pipeline otherwiseBlock;

    public Condition[] getWhenConditions() {
        return this.whenConditions;
    }

    public void setWhenConditions(Condition[] whenConditions) {
        this.whenConditions = whenConditions;
    }

    public Pipeline[] getWhenBlocks() {
        return this.whenBlocks;
    }

    public void setWhenBlocks(Pipeline[] whenBlocks) {
        this.whenBlocks = whenBlocks;
    }

    public Pipeline getOtherwiseBlock() {
        return this.otherwiseBlock;
    }

    public void setOtherwiseBlock(Pipeline otherwiseBlock) {
        this.otherwiseBlock = otherwiseBlock;
    }

    @Override
    protected void init() throws Exception {
        if (this.whenConditions == null) {
            this.whenConditions = new Condition[0];
        }
        if (this.whenBlocks == null) {
            this.whenBlocks = new Pipeline[0];
        }
        Assert.assertTrue(this.whenConditions.length == this.whenBlocks.length, "conditions and blocks not match: %d conditions and %d blocks", this.whenConditions.length, this.whenBlocks.length);
        for (int i = 0; i < this.whenConditions.length; ++i) {
            Assert.assertNotNull(this.whenConditions[i], "when[%d].condition == null", i);
            Assert.assertNotNull(this.whenBlocks[i], "when[%d] == null", i);
        }
    }

    @Override
    public void invoke(PipelineContext pipelineContext) throws Exception {
        this.assertInitialized();
        boolean satisfied = false;
        for (int i = 0; i < this.whenConditions.length; ++i) {
            if (!this.whenConditions[i].isSatisfied(pipelineContext)) continue;
            satisfied = true;
            this.whenBlocks[i].newInvocation(pipelineContext).invoke();
            break;
        }
        if (!satisfied && this.otherwiseBlock != null) {
            this.otherwiseBlock.newInvocation(pipelineContext).invoke();
        }
        pipelineContext.invokeNext();
    }

    @Override
    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder();
        mb.append("whenConditions", this.whenConditions);
        mb.append("whenBlocks", this.whenBlocks);
        mb.append("otherwiseBlock", this.otherwiseBlock);
        return new ToStringBuilder().append("ChooseValve").append(mb).toString();
    }

    public static class DefinitionParser
    extends AbstractValveDefinitionParser<ChooseValve> {
        protected final void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
            List<Object> whenConditions = SpringExtUtil.createManagedList(element, parserContext);
            List<Object> whenBlocks = SpringExtUtil.createManagedList(element, parserContext);
            DomUtil.ElementSelector whenSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("when"));
            DomUtil.ElementSelector otherwiseSelector = DomUtil.and(DomUtil.sameNs(element), DomUtil.name("otherwise"));
            for (Element subElement : DomUtil.subElements(element)) {
                if (whenSelector.accept(subElement)) {
                    whenConditions.add(this.parseCondition(subElement, parserContext, builder));
                    whenBlocks.add(this.parsePipeline(subElement, element, parserContext));
                    continue;
                }
                if (!otherwiseSelector.accept(subElement)) continue;
                builder.addPropertyValue("otherwiseBlock", this.parsePipeline(subElement, element, parserContext));
            }
            builder.addPropertyValue("whenConditions", whenConditions);
            builder.addPropertyValue("whenBlocks", whenBlocks);
        }
    }
}

