/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.moduleloader.impl.adapter;

import com.alibaba.citrus.service.dataresolver.DataResolver;
import com.alibaba.citrus.service.dataresolver.DataResolverService;
import com.alibaba.citrus.service.moduleloader.ModuleAdapterFactory;
import com.alibaba.citrus.service.moduleloader.ModuleInfo;
import com.alibaba.citrus.service.moduleloader.UnadaptableModuleException;
import com.alibaba.citrus.service.moduleloader.impl.adapter.MethodInvoker;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import net.sf.cglib.reflect.FastMethod;

public abstract class AbstractDataBindingAdapterFactory
implements ModuleAdapterFactory {
    private DataResolverService dataResolverService;

    public void setDataResolverService(DataResolverService dataResolverService) {
        this.dataResolverService = dataResolverService;
    }

    protected Method getMethod(Class<?> moduleClass, String methodName) {
        for (Method candidateMethod : moduleClass.getMethods()) {
            if (!candidateMethod.getName().equals(methodName) || !this.checkMethod(candidateMethod)) continue;
            return candidateMethod;
        }
        return null;
    }

    protected boolean checkMethod(Method method) {
        int modifiers = method.getModifiers();
        if (Modifier.isStatic(modifiers)) {
            return false;
        }
        return Modifier.isPublic(modifiers) || Modifier.isProtected(modifiers);
    }

    protected MethodInvoker getMethodInvoker(FastMethod fastMethod, ModuleInfo moduleInfo, boolean skippable) {
        if (fastMethod == null) {
            return null;
        }
        DataResolver[] resolvers = null;
        if (this.dataResolverService != null) {
            resolvers = this.dataResolverService.getParameterResolvers(fastMethod.getJavaMethod(), moduleInfo);
        } else {
            Method javaMethod = fastMethod.getJavaMethod();
            int paramsCount = javaMethod.getParameterTypes().length;
            if (paramsCount > 0) {
                throw new UnadaptableModuleException(String.format("Could not adapt object to module: type=%s, name=%s, class=%s: method %s has %d parameters, but no DataResolvers defined.", moduleInfo.getType(), moduleInfo.getName(), javaMethod.getDeclaringClass().getName(), javaMethod.getName(), paramsCount));
            }
        }
        return new MethodInvoker(fastMethod, resolvers, skippable);
    }
}

