/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.moduleloader.impl;

import com.alibaba.citrus.service.moduleloader.impl.ModuleLoaderServiceImpl;
import com.alibaba.citrus.service.moduleloader.impl.adapter.AbstractDataBindingAdapterFactoryDefinitionParser;
import com.alibaba.citrus.service.moduleloader.impl.adapter.ActionEventAdapterFactory;
import com.alibaba.citrus.service.moduleloader.impl.adapter.DataBindingAdapterFactory;
import com.alibaba.citrus.springext.ConfigurationPoint;
import com.alibaba.citrus.springext.Contribution;
import com.alibaba.citrus.springext.ContributionAware;
import com.alibaba.citrus.springext.support.parser.AbstractNamedBeanDefinitionParser;
import com.alibaba.citrus.springext.util.DomUtil;
import com.alibaba.citrus.springext.util.SpringExtUtil;
import com.alibaba.citrus.util.StringUtil;
import java.util.List;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class ModuleLoaderServiceDefinitionParser
extends AbstractNamedBeanDefinitionParser<ModuleLoaderServiceImpl>
implements ContributionAware {
    private ConfigurationPoint moduleFactoriesConfigurationPoint;
    private ConfigurationPoint moduleAdaptersConfigurationPoint;

    @Override
    public void setContribution(Contribution contrib) {
        this.moduleFactoriesConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/module-loader/factories", contrib);
        this.moduleAdaptersConfigurationPoint = SpringExtUtil.getSiblingConfigurationPoint("services/module-loader/adapters", contrib);
    }

    protected void doParse(Element element, ParserContext parserContext, BeanDefinitionBuilder builder) {
        SpringExtUtil.parseBeanDefinitionAttributes(element, parserContext, builder);
        SpringExtUtil.attributesToProperties(element, builder, "cacheEnabled");
        List<Object> factoryList = SpringExtUtil.createManagedList(element, parserContext);
        List<Object> adapterList = SpringExtUtil.createManagedList(element, parserContext);
        for (Element subElement : DomUtil.subElements(element)) {
            BeanDefinitionHolder factory = SpringExtUtil.parseConfigurationPointBean(subElement, this.moduleFactoriesConfigurationPoint, parserContext, builder);
            if (factory != null) {
                factoryList.add(factory.getBeanDefinition());
                continue;
            }
            BeanDefinitionHolder adapter = SpringExtUtil.parseConfigurationPointBean(subElement, this.moduleAdaptersConfigurationPoint, parserContext, builder);
            if (adapter == null) continue;
            adapterList.add(adapter.getBeanDefinition());
        }
        String includeDefaultAdaptersValue = StringUtil.trimToNull(element.getAttribute("includeDefaultAdapters"));
        boolean includeDefaultAdapters = true;
        if (includeDefaultAdaptersValue != null) {
            includeDefaultAdapters = Boolean.parseBoolean(includeDefaultAdaptersValue);
        }
        if (includeDefaultAdapters) {
            this.addDefaultAdapter(adapterList, ActionEventAdapterFactory.class);
            this.addDefaultAdapter(adapterList, DataBindingAdapterFactory.class);
        }
        builder.addPropertyValue("factories", factoryList);
        builder.addPropertyValue("adapters", adapterList);
    }

    private void addDefaultAdapter(List<Object> adapterList, Class<?> beanClass) {
        boolean found = false;
        for (Object defObject : adapterList) {
            String beanName = ((BeanDefinition)defObject).getBeanClassName();
            if (!beanClass.getName().equals(beanName)) continue;
            found = true;
            break;
        }
        if (!found) {
            BeanDefinitionBuilder builder = BeanDefinitionBuilder.genericBeanDefinition(beanClass);
            AbstractDataBindingAdapterFactoryDefinitionParser.initAdapterBeanDefinition(null, builder);
            adapterList.add(builder.getBeanDefinition());
        }
    }

    @Override
    protected String getDefaultName() {
        return "moduleLoaderService";
    }
}

