/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.mail.impl;

import com.alibaba.citrus.service.mail.builder.MailAddressType;
import com.alibaba.citrus.service.mail.builder.MailBuilder;
import com.alibaba.citrus.service.mail.builder.MailContent;
import java.util.Map;
import org.springframework.beans.factory.FactoryBean;

public class MailBuilderFactory
implements FactoryBean {
    private final MailBuilder builder = new MailBuilder();

    public void setCharset(String javaCharset) {
        this.builder.setCharacterEncoding(javaCharset);
    }

    public void setAddresses(Map<MailAddressType, String[]> addrList) {
        for (Map.Entry<MailAddressType, String[]> entry : addrList.entrySet()) {
            String[] addrs;
            MailAddressType addrType = entry.getKey();
            for (String addr : addrs = entry.getValue()) {
                this.builder.addAddress(addrType, addr);
            }
        }
    }

    public void setSubject(String subject) {
        this.builder.setSubject(subject);
    }

    public void setContent(MailContent content) {
        this.builder.setContent(content);
    }

    public Object getObject() throws Exception {
        return this.builder;
    }

    public Class<?> getObjectType() {
        return this.builder.getClass();
    }

    public boolean isSingleton() {
        return true;
    }
}

