/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.form.impl;

import com.alibaba.citrus.service.form.Field;
import com.alibaba.citrus.service.form.Form;
import com.alibaba.citrus.service.form.Group;
import com.alibaba.citrus.service.form.InvalidGroupStateException;
import com.alibaba.citrus.service.form.MessageContext;
import com.alibaba.citrus.service.form.configuration.FieldConfig;
import com.alibaba.citrus.service.form.configuration.GroupConfig;
import com.alibaba.citrus.service.form.impl.FieldImpl;
import com.alibaba.citrus.service.form.impl.FormImpl;
import com.alibaba.citrus.service.form.impl.FormParameters;
import com.alibaba.citrus.service.form.impl.MessageContextFactory;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.ObjectUtil;
import com.alibaba.citrus.util.StringUtil;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditor;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.BeanWrapperImpl;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.core.CollectionFactory;
import org.springframework.core.MethodParameter;

public class GroupImpl
implements Group {
    protected static final Logger log = LoggerFactory.getLogger(Group.class);
    private final GroupConfig groupConfig;
    private final Form form;
    private final String groupKey;
    private final String instanceKey;
    private final Map<String, Field> fields = CollectionUtil.createLinkedHashMap();
    private final Collection<Field> fieldList = Collections.unmodifiableCollection(this.fields.values());
    private final MessageContext messageContext;
    private boolean validated;
    private boolean valid;

    public GroupImpl(GroupConfig groupConfig, Form form, String instanceKey) {
        this.groupConfig = groupConfig;
        this.form = form;
        this.instanceKey = instanceKey;
        this.groupKey = form.getKey() + "." + groupConfig.getKey() + "." + instanceKey;
        this.messageContext = MessageContextFactory.newInstance(this);
    }

    @Override
    public GroupConfig getGroupConfig() {
        return this.groupConfig;
    }

    @Override
    public Form getForm() {
        return this.form;
    }

    @Override
    public String getName() {
        return this.getGroupConfig().getName();
    }

    @Override
    public String getKey() {
        return this.groupKey;
    }

    @Override
    public String getInstanceKey() {
        return this.instanceKey;
    }

    @Override
    public boolean isValid() {
        return this.valid;
    }

    protected void setValid(boolean valid) {
        this.valid &= valid;
        ((FormImpl)this.getForm()).setValid(this.valid);
    }

    @Override
    public boolean isValidated() {
        return this.validated;
    }

    @Override
    public void init() {
        this.init(null);
    }

    void init(FormParameters request) {
        this.fields.clear();
        this.valid = true;
        this.validated = request != null;
        for (FieldConfig fieldConfig : this.getGroupConfig().getFieldConfigList()) {
            FieldImpl field = new FieldImpl(fieldConfig, this);
            this.fields.put(StringUtil.toLowerCase(fieldConfig.getName()), field);
            field.init(request);
        }
        if (request != null) {
            for (Field field : this.fields.values()) {
                ((FieldImpl)field).validate();
            }
        }
    }

    @Override
    public void validate() {
        this.valid = true;
        this.validated = true;
        for (Field field : this.getFields()) {
            ((FieldImpl)field).validate();
        }
    }

    @Override
    public Collection<Field> getFields() {
        return this.fieldList;
    }

    @Override
    public Field getField(String fieldName) {
        return this.fields.get(StringUtil.toLowerCase(fieldName));
    }

    protected MessageContext getMessageContext() {
        return this.messageContext;
    }

    @Override
    public void mapTo(Object object) {
        if (this.isValidated() || object == null) {
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug("Mapping properties to fields: group=\"{}\", object={}", (Object)this.getName(), (Object)ObjectUtil.identityToString(object));
        }
        BeanWrapperImpl bean = new BeanWrapperImpl(object);
        this.getForm().getFormConfig().getPropertyEditorRegistrar().registerCustomEditors((PropertyEditorRegistry)bean);
        for (Field field : this.getFields()) {
            String propertyName = field.getFieldConfig().getPropertyName();
            if (bean.isReadableProperty(propertyName)) {
                Object propertyValue = bean.getPropertyValue(propertyName);
                Class propertyType = bean.getPropertyType(propertyName);
                PropertyEditor editor = bean.findCustomEditor(propertyType, propertyName);
                if (editor == null) {
                    editor = BeanUtils.findEditorByConvention((Class)propertyType);
                }
                if (editor == null) {
                    if (propertyType.isArray() || CollectionFactory.isApproximableCollectionType((Class)propertyType)) {
                        field.setValues((String[])bean.convertIfNecessary(propertyValue, String[].class));
                        continue;
                    }
                    field.setValue(bean.convertIfNecessary(propertyValue, String.class));
                    continue;
                }
                editor.setValue(propertyValue);
                field.setValue(editor.getAsText());
                continue;
            }
            log.debug("No readable property \"{}\" found in type {}", (Object)propertyName, (Object)object.getClass().getName());
        }
    }

    @Override
    public void setProperties(Object object) {
        if (!this.isValidated() || object == null) {
            return;
        }
        if (this.isValid()) {
            if (log.isDebugEnabled()) {
                log.debug("Set validated properties of group \"" + this.getName() + "\" to object " + ObjectUtil.identityToString(object));
            }
            BeanWrapperImpl bean = new BeanWrapperImpl(object);
            this.getForm().getFormConfig().getPropertyEditorRegistrar().registerCustomEditors((PropertyEditorRegistry)bean);
            for (Field field : this.getFields()) {
                String propertyName = field.getFieldConfig().getPropertyName();
                if (bean.isWritableProperty(propertyName)) {
                    PropertyDescriptor pd = bean.getPropertyDescriptor(propertyName);
                    MethodParameter mp = BeanUtils.getWriteMethodParameter((PropertyDescriptor)pd);
                    Object value = field.getValueOfType(pd.getPropertyType(), mp, null);
                    bean.setPropertyValue(propertyName, value);
                    continue;
                }
                log.debug("No writable property \"{}\" found in type {}", (Object)propertyName, (Object)object.getClass().getName());
            }
        } else {
            throw new InvalidGroupStateException("Attempted to call setProperties from an invalid input");
        }
    }

    public String toString() {
        return "Group[name: " + this.getName() + "." + this.getInstanceKey() + ", fields: " + this.getGroupConfig().getFieldConfigList().size() + ", validated: " + this.isValidated() + ", valid: " + this.isValid() + "]";
    }
}

