/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.configuration.support;

import com.alibaba.citrus.service.AbstractService;
import com.alibaba.citrus.service.configuration.Configuration;
import com.alibaba.citrus.util.Assert;
import com.alibaba.citrus.util.CollectionUtil;
import com.alibaba.citrus.util.StringUtil;
import com.alibaba.citrus.util.ToStringBuilder;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;

public abstract class PropertiesConfigurationSupport<C extends Configuration>
extends AbstractService<C>
implements Configuration,
ApplicationContextAware {
    private final Map<String, Object> props = CollectionUtil.createHashMap();
    private PropertiesConfigurationSupport<C> parent;
    private ApplicationContext factory;

    public PropertiesConfigurationSupport() {
        this(null);
    }

    public PropertiesConfigurationSupport(PropertiesConfigurationSupport<C> parent) {
        this.parent = parent;
    }

    public void setApplicationContext(ApplicationContext factory) throws BeansException {
        this.factory = factory;
    }

    @Override
    protected void init() {
        Assert.assertNotNull(this.factory, "beanFactory", new Object[0]);
        if (this.parent == null && this.factory.getParent() != null && this.factory.getParent().containsBean(this.getDefaultName())) {
            this.parent = (PropertiesConfigurationSupport)this.factory.getParent().getBean(this.getDefaultName());
        }
        if (this.hasParent()) {
            Boolean productionMode = (Boolean)this.getPropertyNoParent("productionMode");
            if (this.parent.isProductionMode()) {
                Assert.assertTrue(productionMode == null || productionMode != false, "productionMode cannot be disabled at App's Context", new Object[0]);
            }
        }
        if (!this.isProductionMode()) {
            this.getLogger().warn("Application is running in Development Mode.");
        } else {
            this.getLogger().info("Application is running in Production Mode.");
        }
    }

    @Override
    public boolean isProductionMode() {
        return this.getProperty("productionMode", Boolean.TRUE);
    }

    public void setProductionMode(boolean productionMode) {
        this.setProperty("productionMode", productionMode);
    }

    protected final boolean hasParent() {
        return this.parent != null;
    }

    protected abstract String getDefaultName();

    protected Set<String> keySet() {
        if (this.parent == null) {
            return this.props.keySet();
        }
        HashSet<String> keys = CollectionUtil.createHashSet();
        keys.addAll(this.parent.keySet());
        keys.addAll(this.props.keySet());
        return keys;
    }

    protected Object getPropertyNoParent(String key) {
        return this.props.get(key);
    }

    protected <T> T getProperty(String key, T defaultValue) {
        Object value = this.getPropertyNoParent(key);
        if (value == null) {
            value = this.parent == null ? defaultValue : this.parent.getProperty(key, defaultValue);
        }
        Object result = value;
        return (T)result;
    }

    protected <T> T getBean(String key, String defaultBeanName, Class<T> beanType) {
        return this.getBean(key, defaultBeanName, beanType, true);
    }

    protected <T> T getBean(String key, String defaultBeanName, Class<T> beanType, boolean required) {
        String beanName = this.getProperty(key, defaultBeanName);
        if (required || this.factory.containsBean(beanName)) {
            return beanType.cast(this.factory.getBean(beanName, beanType));
        }
        return null;
    }

    protected void setProperty(String key, Object value) {
        if (value instanceof String) {
            value = StringUtil.trimToNull((String)value);
        }
        if (value == null) {
            this.props.remove(key);
        } else {
            this.props.put(key, value);
        }
    }

    @Override
    public String toString() {
        ToStringBuilder.MapBuilder mb = new ToStringBuilder.MapBuilder().setSortKeys(true).setPrintCount(true);
        for (String key : this.keySet()) {
            Object parentValue = this.parent == null ? null : this.parent.getProperty(key, null);
            Object value = this.props.get(key);
            if (parentValue != null && value == null) {
                mb.append(key + " (inherited)", parentValue);
                continue;
            }
            if (parentValue != null && value != null) {
                mb.append(key + " (overrided)", value);
                continue;
            }
            mb.append(key, value);
        }
        return new ToStringBuilder().append(this.getBeanDescription()).append(mb).toString();
    }
}

