/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.citrus.service.configuration.support;

import com.alibaba.citrus.util.i18n.LocaleUtil;
import java.beans.PropertyEditor;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import org.springframework.beans.PropertyEditorRegistrar;
import org.springframework.beans.PropertyEditorRegistry;
import org.springframework.beans.propertyeditors.CustomDateEditor;

public class CustomDateRegistrar
implements PropertyEditorRegistrar {
    private String format;
    private Locale locale;
    private TimeZone timeZone;

    public String getFormat() {
        return this.format;
    }

    public void setFormat(String format) {
        this.format = format;
    }

    public void setLocale(String locale) {
        this.locale = LocaleUtil.parseLocale(locale);
    }

    public void setTimeZone(String timeZone) {
        this.timeZone = TimeZone.getTimeZone(timeZone);
    }

    public void registerCustomEditors(PropertyEditorRegistry registry) {
        if (this.format == null) {
            this.format = "yyyy-MM-dd";
        }
        if (this.locale == null) {
            this.locale = LocaleUtil.getContext().getLocale();
        }
        if (this.timeZone == null) {
            this.timeZone = TimeZone.getDefault();
        }
        SimpleDateFormat sdf = new SimpleDateFormat(this.format, this.locale);
        sdf.setTimeZone(this.timeZone);
        registry.registerCustomEditor(Date.class, (PropertyEditor)new CustomDateEditor((DateFormat)sdf, true));
    }
}

