/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.boot.nacos.discovery.autoconfigure;

import com.alibaba.boot.nacos.discovery.properties.NacosDiscoveryProperties;
import com.alibaba.boot.nacos.discovery.properties.Register;
import com.alibaba.nacos.api.annotation.NacosInjected;
import com.alibaba.nacos.api.exception.NacosException;
import com.alibaba.nacos.api.naming.NamingService;
import com.alibaba.nacos.api.naming.pojo.Instance;
import com.alibaba.nacos.client.naming.utils.NetUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.context.embedded.EmbeddedServletContainerInitializedEvent;
import org.springframework.context.ApplicationListener;
import org.springframework.stereotype.Component;

@Component
public class NacosDiscoveryAutoRegister
implements ApplicationListener<EmbeddedServletContainerInitializedEvent> {
    private static final Logger logger = LoggerFactory.getLogger(NacosDiscoveryAutoRegister.class);
    @NacosInjected
    private NamingService namingService;
    @Autowired
    private NacosDiscoveryProperties discoveryProperties;
    @Value(value="${spring.application.name:spring.application.name}")
    private String application;

    public void onApplicationEvent(EmbeddedServletContainerInitializedEvent event) {
        if (!this.discoveryProperties.isAutoRegister()) {
            return;
        }
        Register register = this.discoveryProperties.getRegister();
        if (StringUtils.isEmpty((CharSequence)register.getIp())) {
            register.setIp(NetUtils.localIP());
        }
        if (register.getPort() == 0) {
            register.setPort(event.getSource().getPort());
        }
        register.getMetadata().put("preserved.register.source", "SPRING_BOOT");
        register.setInstanceId("");
        String serviceName = StringUtils.isEmpty((CharSequence)register.getServiceName()) ? this.application : register.getServiceName();
        try {
            this.namingService.registerInstance(serviceName, register.getGroupName(), (Instance)register);
            logger.info("Finished auto register service : {}, ip : {}, port : {}", new Object[]{register.getServiceName(), register.getIp(), register.getPort()});
        }
        catch (NacosException e) {
            throw new RuntimeException(e);
        }
    }
}

