/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.runtime.tasks.StreamTaskConfig;
import org.apache.flink.streaming.runtime.tasks.StreamTaskConfigSnapshot;
import org.apache.flink.util.Preconditions;

@Internal
public class StreamTaskConfigCache
implements StreamTaskConfigSnapshot {
    private final ClassLoader classLoader;
    private TimeCharacteristic timeChar;
    private Map<Integer, StreamConfig> chainedNodeConfigMap;
    private List<Integer> chainedHeadNodeIds;
    private List<StreamEdge> inStreamEdgesOfChain;
    private List<StreamEdge> outStreamEdgesOfChain;
    private boolean isCheckpointingEnabled;
    private CheckpointingMode checkpointMode;
    private StateBackend stateBackend;

    public StreamTaskConfigCache(ClassLoader classLoader) {
        this(null, classLoader);
    }

    private StreamTaskConfigCache(StreamTaskConfig config, ClassLoader classLoader) {
        this.classLoader = (ClassLoader)Preconditions.checkNotNull((Object)classLoader);
        if (config != null) {
            this.timeChar = config.getTimeCharacteristic();
            this.chainedNodeConfigMap = Collections.unmodifiableMap(config.getChainedNodeConfigs(this.classLoader));
            this.chainedHeadNodeIds = Collections.unmodifiableList(config.getChainedHeadNodeIds(this.classLoader));
            this.inStreamEdgesOfChain = Collections.unmodifiableList(config.getInStreamEdgesOfChain(this.classLoader));
            this.outStreamEdgesOfChain = Collections.unmodifiableList(config.getOutStreamEdgesOfChain(this.classLoader));
            this.isCheckpointingEnabled = config.isCheckpointingEnabled();
            this.checkpointMode = config.getCheckpointMode();
            this.stateBackend = config.getStateBackend(this.classLoader);
        }
    }

    public void clear() {
        this.timeChar = null;
        this.chainedNodeConfigMap = null;
        this.chainedHeadNodeIds = null;
        this.inStreamEdgesOfChain = null;
        this.outStreamEdgesOfChain = null;
        this.isCheckpointingEnabled = false;
        this.checkpointMode = null;
        this.stateBackend = null;
    }

    public void serializeTo(StreamTaskConfig config) {
        Preconditions.checkNotNull((Object)config);
        if (this.timeChar != null) {
            config.setTimeCharacteristic(this.timeChar);
        }
        config.setChainedNodeConfigs(this.chainedNodeConfigMap);
        config.setChainedHeadNodeIds(this.chainedHeadNodeIds);
        config.setInStreamEdgesOfChain(this.inStreamEdgesOfChain);
        config.setOutStreamEdgesOfChain(this.outStreamEdgesOfChain);
        config.setCheckpointingEnabled(this.isCheckpointingEnabled);
        config.setCheckpointMode(this.checkpointMode);
        config.setStateBackend(this.stateBackend);
    }

    public static StreamTaskConfigCache deserializeFrom(StreamTaskConfig config, ClassLoader classLoader) {
        return new StreamTaskConfigCache((StreamTaskConfig)Preconditions.checkNotNull((Object)config), classLoader);
    }

    public void setTimeCharacteristic(TimeCharacteristic characteristic) {
        this.timeChar = characteristic;
    }

    @Override
    public TimeCharacteristic getTimeCharacteristic() {
        return this.timeChar;
    }

    public void setInStreamEdgesOfChain(List<StreamEdge> inEdges) {
        this.inStreamEdgesOfChain = inEdges;
    }

    @Override
    public List<StreamEdge> getInStreamEdgesOfChain() {
        return this.inStreamEdgesOfChain;
    }

    public void setOutStreamEdgesOfChain(List<StreamEdge> outEdges) {
        this.outStreamEdgesOfChain = outEdges;
    }

    @Override
    public List<StreamEdge> getOutStreamEdgesOfChain() {
        return this.outStreamEdgesOfChain;
    }

    public void setChainedNodeConfigs(Map<Integer, StreamConfig> chainedConfigMap) {
        this.chainedNodeConfigMap = chainedConfigMap;
    }

    @Override
    public Map<Integer, StreamConfig> getChainedNodeConfigs() {
        return this.chainedNodeConfigMap;
    }

    public void setChainedHeadNodeIds(List<Integer> headNodeIds) {
        this.chainedHeadNodeIds = headNodeIds;
    }

    @Override
    public List<Integer> getChainedHeadNodeIds() {
        return this.chainedHeadNodeIds;
    }

    @Override
    public List<StreamConfig> getChainedHeadNodeConfigs() {
        return Collections.unmodifiableList(StreamTaskConfig.getStreamConfigOfHeadNodes(this.getChainedHeadNodeIds(), this.getChainedNodeConfigs()));
    }

    public void setCheckpointingEnabled(boolean enabled) {
        this.isCheckpointingEnabled = enabled;
    }

    @Override
    public boolean isCheckpointingEnabled() {
        return this.isCheckpointingEnabled;
    }

    public void setCheckpointMode(CheckpointingMode mode) {
        this.checkpointMode = mode;
    }

    @Override
    public CheckpointingMode getCheckpointMode() {
        return this.checkpointMode;
    }

    public void setStateBackend(StateBackend backend) {
        this.stateBackend = backend;
    }

    @Override
    public StateBackend getStateBackend() {
        return this.stateBackend;
    }

    public String toString() {
        return "TimeCharacteristic: " + (Object)((Object)this.timeChar) + ", chainedNodeConfigMap: " + this.chainedNodeConfigMap + ", chainedHeadNodeIds: " + this.chainedHeadNodeIds + ", inStreamEdgesOfChain: " + this.inStreamEdgesOfChain + ", outStreamEdgesOfChain: " + this.outStreamEdgesOfChain + ", isCheckpointingEnabled: " + this.isCheckpointingEnabled + ", checkpointMode: " + (Object)((Object)this.checkpointMode) + ", stateBackend: " + this.stateBackend;
    }
}

