/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.state.StateBackend;
import org.apache.flink.streaming.api.CheckpointingMode;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.graph.StreamConfig;
import org.apache.flink.streaming.api.graph.StreamEdge;
import org.apache.flink.streaming.runtime.tasks.StreamTaskException;
import org.apache.flink.util.InstantiationUtil;

@Internal
public class StreamTaskConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final String TIME_CHARACTERISTIC = "timechar";
    private static final String CHAINED_NODE_CONFIGS = "chainedNodeConfigs";
    private static final String CHAINED_HEAD_NODE_IDS = "chainedHeadNodeIds";
    private static final String CHAIN_IN_STREAM_EDGES = "chainInStreamEdges";
    private static final String CHAIN_OUT_STREAM_EDGES = "chainOutStreamEdges";
    private static final String CHECKPOINTING_ENABLED = "checkpointing";
    private static final String CHECKPOINT_MODE = "checkpointMode";
    private static final String STATE_BACKEND = "statebackend";
    private final Configuration config;

    public StreamTaskConfig(Configuration config) {
        this.config = config;
    }

    public Configuration getConfiguration() {
        return this.config;
    }

    public void setTimeCharacteristic(TimeCharacteristic characteristic) {
        this.config.setInteger(TIME_CHARACTERISTIC, characteristic.ordinal());
    }

    public TimeCharacteristic getTimeCharacteristic() {
        int ordinal = this.config.getInteger(TIME_CHARACTERISTIC, -1);
        if (ordinal >= 0) {
            return TimeCharacteristic.values()[ordinal];
        }
        return null;
    }

    public void setInStreamEdgesOfChain(List<StreamEdge> inEdges) {
        try {
            InstantiationUtil.writeObjectToConfig(inEdges, (Configuration)this.config, (String)CHAIN_IN_STREAM_EDGES);
        }
        catch (IOException e) {
            throw new StreamTaskException("Cannot serialize inward edges.", e);
        }
    }

    public List<StreamEdge> getInStreamEdgesOfChain(ClassLoader cl) {
        try {
            List inEdges = (List)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)CHAIN_IN_STREAM_EDGES, (ClassLoader)cl);
            return inEdges == null ? new ArrayList() : inEdges;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate inputs.", e);
        }
    }

    public void setOutStreamEdgesOfChain(List<StreamEdge> outEdgeList) {
        try {
            InstantiationUtil.writeObjectToConfig(outEdgeList, (Configuration)this.config, (String)CHAIN_OUT_STREAM_EDGES);
        }
        catch (IOException e) {
            throw new StreamTaskException("Could not serialize outputs in order.", e);
        }
    }

    public List<StreamEdge> getOutStreamEdgesOfChain(ClassLoader cl) {
        try {
            List outEdgesInOrder = (List)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)CHAIN_OUT_STREAM_EDGES, (ClassLoader)cl);
            return outEdgesInOrder == null ? new ArrayList() : outEdgesInOrder;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate outputs in order.", e);
        }
    }

    public void setChainedNodeConfigs(Map<Integer, StreamConfig> chainedTaskConfigs) {
        try {
            InstantiationUtil.writeObjectToConfig(chainedTaskConfigs, (Configuration)this.config, (String)CHAINED_NODE_CONFIGS);
        }
        catch (IOException e) {
            throw new StreamTaskException("Could not serialize configuration.", e);
        }
    }

    public Map<Integer, StreamConfig> getChainedNodeConfigs(ClassLoader cl) {
        try {
            Map confs = (Map)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)CHAINED_NODE_CONFIGS, (ClassLoader)cl);
            return confs == null ? new HashMap() : confs;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate configuration.", e);
        }
    }

    public void setChainedHeadNodeIds(List<Integer> headNodeIds) {
        try {
            InstantiationUtil.writeObjectToConfig(headNodeIds, (Configuration)this.config, (String)CHAINED_HEAD_NODE_IDS);
        }
        catch (IOException e) {
            throw new StreamTaskException("Cannot serialize chained head node list.", e);
        }
    }

    public List<Integer> getChainedHeadNodeIds(ClassLoader cl) {
        try {
            List headNodeIds = (List)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)CHAINED_HEAD_NODE_IDS, (ClassLoader)cl);
            return headNodeIds == null ? new ArrayList() : headNodeIds;
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate outputs in order.", e);
        }
    }

    public List<StreamConfig> getStreamConfigOfHeadNodes(ClassLoader cl) {
        return StreamTaskConfig.getStreamConfigOfHeadNodes(this.getChainedHeadNodeIds(cl), this.getChainedNodeConfigs(cl));
    }

    public static List<StreamConfig> getStreamConfigOfHeadNodes(List<Integer> headNodeIds, Map<Integer, StreamConfig> chainedConfigs) {
        if (headNodeIds == null || chainedConfigs == null) {
            return new ArrayList<StreamConfig>();
        }
        return headNodeIds.stream().map(nodeId -> {
            if (!chainedConfigs.containsKey(nodeId)) {
                throw new StreamTaskException("Could not find StreamConfig of the node (nodeId: " + nodeId + ").");
            }
            return (StreamConfig)chainedConfigs.get(nodeId);
        }).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public void setCheckpointingEnabled(boolean enabled) {
        this.config.setBoolean(CHECKPOINTING_ENABLED, enabled);
    }

    public boolean isCheckpointingEnabled() {
        return this.config.getBoolean(CHECKPOINTING_ENABLED, false);
    }

    public void setCheckpointMode(CheckpointingMode mode) {
        this.config.setInteger(CHECKPOINT_MODE, mode.ordinal());
    }

    public CheckpointingMode getCheckpointMode() {
        int ordinal = this.config.getInteger(CHECKPOINT_MODE, -1);
        if (ordinal >= 0) {
            return CheckpointingMode.values()[ordinal];
        }
        return StreamConfig.DEFAULT_CHECKPOINTING_MODE;
    }

    public void setStateBackend(StateBackend backend) {
        if (backend != null) {
            try {
                InstantiationUtil.writeObjectToConfig((Object)backend, (Configuration)this.config, (String)STATE_BACKEND);
            }
            catch (Exception e) {
                throw new StreamTaskException("Could not serialize stateHandle provider.", e);
            }
        }
    }

    public StateBackend getStateBackend(ClassLoader cl) {
        try {
            return (StateBackend)InstantiationUtil.readObjectFromConfig((Configuration)this.config, (String)STATE_BACKEND, (ClassLoader)cl);
        }
        catch (Exception e) {
            throw new StreamTaskException("Could not instantiate statehandle provider.", e);
        }
    }

    public String toString() {
        ClassLoader cl = this.getClass().getClassLoader();
        List<Integer> headNodeIds = this.getChainedHeadNodeIds(cl);
        Map<Integer, StreamConfig> chainConfigs = this.getChainedNodeConfigs(cl);
        StringBuilder builder = new StringBuilder();
        builder.append("\n=======================");
        builder.append("StreamTask Config");
        builder.append("=======================");
        builder.append("\nChained subTasks num: ").append(chainConfigs.size());
        builder.append("\nNumber of non-chained outputs: ").append(this.getOutStreamEdgesOfChain(cl).size());
        builder.append("\nNon-chained outputs: ").append(this.getOutStreamEdgesOfChain(cl));
        builder.append("\nPartitioning:");
        for (StreamEdge output : this.getOutStreamEdgesOfChain(cl)) {
            int outputName = output.getTargetId();
            builder.append("\n\t").append(outputName).append(": ").append(output.getPartitioner());
        }
        builder.append("\nHead nodeIds: ").append(Arrays.toString((Object[])headNodeIds.toArray(new Integer[0])));
        try {
            builder.append("\nHead operators: " + Arrays.toString(StreamTaskConfig.getStreamConfigOfHeadNodes(headNodeIds, chainConfigs).stream().map(config -> config.getStreamOperator(cl).getClass().getSimpleName()).toArray(String[]::new)));
        }
        catch (Throwable t) {
            builder.append("\nHead Operators: ").append(t.getMessage());
        }
        try {
            builder.append("\nTimeCharacteristic: " + (Object)((Object)this.getTimeCharacteristic()));
        }
        catch (Throwable t) {
            builder.append("\nTimeCharacteristic: ").append(t.getMessage());
        }
        builder.append("\nState monitoring: ").append(this.isCheckpointingEnabled());
        builder.append("\nCheckpoint mode: ").append((Object)this.getCheckpointMode());
        try {
            StateBackend stateBackend = this.getStateBackend(cl);
            builder.append("\nStateBackend: " + (stateBackend == null ? null : stateBackend.getClass().getName()));
        }
        catch (Throwable t) {
            builder.append("\nStateBackend: ").append(t.getMessage());
        }
        builder.append("\n\n\n---------------------\nChained subTask configs\n---------------------\n");
        builder.append(chainConfigs);
        return builder.toString();
    }
}

