/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.tasks;

import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.execution.Environment;
import org.apache.flink.streaming.api.TimeCharacteristic;
import org.apache.flink.streaming.api.functions.source.SourceFunction;
import org.apache.flink.streaming.api.functions.source.SourceFunctionV2;
import org.apache.flink.streaming.api.functions.source.SourceRecord;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.api.operators.StreamSourceContexts;
import org.apache.flink.streaming.api.operators.StreamSourceV2;
import org.apache.flink.streaming.runtime.tasks.StreamTask;
import org.apache.flink.util.Preconditions;
import org.apache.flink.util.checkpointlock.CheckpointLockDelegate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Internal
public class InputFormatSourceStreamTaskV2<OUT, SRC extends SourceFunctionV2<OUT>, OP extends StreamSourceV2<OUT, SRC>>
extends StreamTask<OUT, OP> {
    private static final Logger LOG = LoggerFactory.getLogger(InputFormatSourceStreamTaskV2.class);
    private boolean running = true;

    public InputFormatSourceStreamTaskV2(Environment env) {
        super(env);
    }

    @Override
    protected void init() {
    }

    @Override
    protected void cleanup() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void run() throws Exception {
        OP headOperator = this.getHeadOperator();
        TimeCharacteristic timeCharacteristic = ((AbstractStreamOperator)headOperator).getOperatorConfig().getTimeCharacteristic();
        Output collector = ((AbstractStreamOperator)headOperator).getOutput();
        long watermarkInterval = ((AbstractStreamOperator)headOperator).getRuntimeContext().getExecutionConfig().getAutoWatermarkInterval();
        try (SourceFunction.SourceContext ctx = StreamSourceContexts.getSourceContext(timeCharacteristic, this.getProcessingTimeService(), this.getCheckpointLock(), this.getStreamStatusMaintainer(), collector, watermarkInterval, -1L);){
            SourceRecord sourceRecord;
            while (this.running && (sourceRecord = ((StreamSourceV2)headOperator).next()) != null) {
                Object out = sourceRecord.getRecord();
                if (out == null) continue;
                ctx.collect(out);
            }
            if (this.running) {
                new CheckpointLockDelegate(this.getCheckpointLock()).lockAndRun(() -> {
                    for (StreamOperator<?> operator : this.operatorChain.getAllOperatorsTopologySorted()) {
                        if (!(operator instanceof OneInputStreamOperator)) continue;
                        ((OneInputStreamOperator)operator).endInput();
                    }
                });
            } else {
                ((StreamSourceV2)headOperator).cancel();
            }
        }
    }

    @Override
    protected void cancelTask() throws Exception {
        this.running = false;
    }

    protected OP getHeadOperator() {
        Preconditions.checkState((this.operatorChain.getHeadOperators().length == 1 ? 1 : 0) != 0, (Object)("There should only one head operator, not " + this.operatorChain.getHeadOperators().length));
        return (OP)((StreamSourceV2)this.operatorChain.getHeadOperators()[0]);
    }
}

