/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamstatus;

import java.util.BitSet;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusMaintainer;

public class StreamStatusSubMaintainer
implements StreamStatusMaintainer {
    private final StreamStatusMaintainer streamStatusMaintainer;
    private final BitSet subStatus;
    private final int subIndex;

    public StreamStatusSubMaintainer(StreamStatusMaintainer streamStatusMaintainer, BitSet subStatus, int subIndex) {
        this.streamStatusMaintainer = streamStatusMaintainer;
        this.subStatus = subStatus;
        this.subIndex = subIndex;
        this.subStatus.set(subIndex, true);
    }

    public void updateStreamStatus(StreamStatus streamStatus) {
        StreamStatus previousStatus = this.getStreamStatus();
        if (previousStatus.equals(streamStatus)) {
            return;
        }
        this.subStatus.set(this.subIndex, streamStatus.isActive());
        if (streamStatus.isActive()) {
            this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.ACTIVE);
        } else if (this.subStatus.isEmpty()) {
            this.streamStatusMaintainer.toggleStreamStatus(StreamStatus.IDLE);
        }
    }

    @Override
    public StreamStatus getStreamStatus() {
        return this.subStatus.get(this.subIndex) ? StreamStatus.ACTIVE : StreamStatus.IDLE;
    }

    @Override
    public void toggleStreamStatus(StreamStatus streamStatus) {
        this.updateStreamStatus(streamStatus);
    }

    public void release() {
        this.subStatus.set(this.subIndex, false);
    }
}

