/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.streamrecord;

import java.io.IOException;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.runtime.plugable.DeserializationDelegate;
import org.apache.flink.streaming.runtime.streamrecord.StreamElement;
import org.apache.flink.streaming.runtime.streamrecord.StreamElementSerializer;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;

public class ReusingRecordValueDeserializationDelegate<IN>
implements DeserializationDelegate<StreamElement> {
    private StreamElement instance;
    private IN lastReusableRecordValueObj;
    private final StreamElementSerializer<IN> serializer;

    public ReusingRecordValueDeserializationDelegate(StreamElementSerializer<IN> serializer) {
        this.serializer = serializer;
    }

    public void setInstance(StreamElement instance) {
        this.instance = instance;
        this.updateLastReusableRecordValueObj();
    }

    public StreamElement getInstance() {
        return this.instance;
    }

    public void write(DataOutputView out) throws IOException {
        throw new IllegalStateException("Serialization method called on DeserializationDelegate.");
    }

    public void read(DataInputView in) throws IOException {
        this.instance = this.lastReusableRecordValueObj == null ? this.serializer.deserialize(in) : this.serializer.deserialize(new StreamRecord<IN>(this.lastReusableRecordValueObj), in);
        this.updateLastReusableRecordValueObj();
    }

    private void updateLastReusableRecordValueObj() {
        StreamRecord record;
        if (this.instance != null && this.instance.isRecord() && (record = this.instance.asRecord()).getValue() != null) {
            this.lastReusableRecordValueObj = record.getValue();
        }
    }
}

