/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import org.apache.flink.runtime.metrics.groups.TaskMetricGroup;
import org.apache.flink.streaming.api.operators.OneInputStreamOperator;
import org.apache.flink.streaming.api.watermark.Watermark;
import org.apache.flink.streaming.runtime.io.InputProcessor;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.streamstatus.StatusWatermarkValve;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatus;
import org.apache.flink.streaming.runtime.streamstatus.StreamStatusSubMaintainer;
import org.apache.flink.util.Preconditions;

class SourceInputProcessor
implements InputProcessor,
StatusWatermarkValve.ValveOutputHandler {
    private final OneInputStreamOperator sourceOperatorProxy;
    private final StatusWatermarkValve statusWatermarkValve;
    private final StreamStatusSubMaintainer streamStatusSubMaintainer;

    public SourceInputProcessor(StreamStatusSubMaintainer streamStatusSubMaintainer, OneInputStreamOperator sourceOperatorProxy, Object checkpointLock, TaskMetricGroup taskMetricGroup, int channelCount) {
        this.streamStatusSubMaintainer = (StreamStatusSubMaintainer)Preconditions.checkNotNull((Object)streamStatusSubMaintainer);
        this.statusWatermarkValve = new StatusWatermarkValve(channelCount, this);
        this.sourceOperatorProxy = (OneInputStreamOperator)Preconditions.checkNotNull((Object)sourceOperatorProxy);
    }

    @Override
    public void processRecord(StreamRecord streamRecord, int channelIndex) throws Exception {
        throw new UnsupportedOperationException("SourceInputProcessor should not process record");
    }

    @Override
    public void processLatencyMarker(LatencyMarker latencyMarker, int channelIndex) throws Exception {
        throw new UnsupportedOperationException("SourceInputProcessor should not process latency marker");
    }

    @Override
    public void processWatermark(Watermark watermark, int channelIndex) throws Exception {
        throw new UnsupportedOperationException("SourceInputProcessor should not process watermark");
    }

    @Override
    public void processStreamStatus(StreamStatus streamStatus, int channelIndex) throws Exception {
        throw new UnsupportedOperationException("SourceInputProcessor should not process stream status");
    }

    @Override
    public void endInput() throws Exception {
        this.sourceOperatorProxy.endInput();
    }

    @Override
    public void handleWatermark(Watermark watermark) {
        throw new UnsupportedOperationException("SourceInputProcessor should not process watermark");
    }

    @Override
    public void handleStreamStatus(StreamStatus streamStatus) {
        this.streamStatusSubMaintainer.updateStreamStatus(streamStatus);
    }

    @Override
    public void release() {
        this.streamStatusSubMaintainer.release();
    }
}

