/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.runtime.io;

import java.util.ArrayList;
import java.util.Collection;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.io.network.partition.consumer.InputGate;
import org.apache.flink.runtime.io.network.partition.consumer.UnionInputGate;

@Internal
public class InputGateUtil {
    public static InputGate createInputGate(Collection<InputGate> ... inputGateGroups) {
        ArrayList<InputGate> gates = new ArrayList<InputGate>();
        for (Collection<InputGate> inputGates : inputGateGroups) {
            gates.addAll(inputGates);
        }
        return InputGateUtil.createInputGate(new InputGate[][]{gates.toArray(new InputGate[0])});
    }

    public static InputGate createInputGate(InputGate[] ... inputGateGroups) {
        if (inputGateGroups.length <= 0) {
            throw new RuntimeException("No such input gate.");
        }
        if (inputGateGroups.length == 1) {
            if (inputGateGroups[0].length == 1) {
                return inputGateGroups[0][0];
            }
            if (inputGateGroups[0].length <= 0) {
                throw new RuntimeException("No such input gate.");
            }
            return new UnionInputGate(inputGateGroups[0]);
        }
        int numGates = 0;
        for (InputGate[] inputGates : inputGateGroups) {
            numGates += inputGates.length;
        }
        if (numGates <= 0) {
            throw new RuntimeException("No such input gate.");
        }
        InputGate[] gates = new InputGate[numGates];
        int index = 0;
        InputGate[][] inputGateArray = inputGateGroups;
        int n = inputGateArray.length;
        for (int i = 0; i < n; ++i) {
            InputGate[] inputGates;
            for (InputGate gate : inputGates = inputGateArray[i]) {
                gates[index++] = gate;
            }
        }
        if (gates.length == 1) {
            return gates[0];
        }
        return new UnionInputGate(gates);
    }

    private InputGateUtil() {
        throw new RuntimeException();
    }
}

