/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.util.concurrent.ScheduledFuture;
import org.apache.flink.annotation.Internal;
import org.apache.flink.runtime.jobgraph.OperatorID;
import org.apache.flink.streaming.api.functions.source.SourceFunctionV2;
import org.apache.flink.streaming.api.functions.source.SourceRecord;
import org.apache.flink.streaming.api.operators.AbstractStreamOperator;
import org.apache.flink.streaming.api.operators.AbstractUdfStreamOperator;
import org.apache.flink.streaming.api.operators.ChainingStrategy;
import org.apache.flink.streaming.api.operators.Output;
import org.apache.flink.streaming.api.operators.StreamOperator;
import org.apache.flink.streaming.runtime.streamrecord.LatencyMarker;
import org.apache.flink.streaming.runtime.streamrecord.StreamRecord;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeCallback;
import org.apache.flink.streaming.runtime.tasks.ProcessingTimeService;

@Internal
public class StreamSourceV2<OUT, SRC extends SourceFunctionV2<OUT>>
extends AbstractUdfStreamOperator<OUT, SRC>
implements StreamOperator<OUT> {
    private static final long serialVersionUID = 1L;
    private transient LatencyMarksEmitter latencyEmitter;

    public StreamSourceV2(SRC sourceFunction) {
        super(sourceFunction);
        this.chainingStrategy = ChainingStrategy.HEAD;
    }

    @Override
    public void open() throws Exception {
        super.open();
        if (this.getExecutionConfig().isLatencyTrackingEnabled()) {
            this.latencyEmitter = new LatencyMarksEmitter(this.getProcessingTimeService(), this.getOutput(), this.getExecutionConfig().getLatencyTrackingInterval(), this.getOperatorID(), this.getRuntimeContext().getIndexOfThisSubtask());
        }
    }

    @Override
    public void close() throws Exception {
        super.close();
        if (this.latencyEmitter != null) {
            this.latencyEmitter.close();
        }
    }

    public SourceRecord<OUT> next() throws Exception {
        return ((SourceFunctionV2)this.userFunction).next();
    }

    public boolean isFinished() {
        return ((SourceFunctionV2)this.userFunction).isFinished();
    }

    public void cancel() {
        ((SourceFunctionV2)this.userFunction).cancel();
    }

    private static class LatencyMarksEmitter<OUT> {
        private final ScheduledFuture<?> latencyMarkTimer;

        public LatencyMarksEmitter(ProcessingTimeService processingTimeService, final Output<StreamRecord<OUT>> output, long latencyTrackingInterval, final OperatorID operatorId, final int subtaskIndex) {
            this.latencyMarkTimer = processingTimeService.scheduleAtFixedRate(new ProcessingTimeCallback(){

                @Override
                public void onProcessingTime(long timestamp) throws Exception {
                    try {
                        output.emitLatencyMarker(new LatencyMarker(timestamp, operatorId, subtaskIndex));
                    }
                    catch (Throwable t) {
                        AbstractStreamOperator.LOG.warn("Error while emitting latency marker.", t);
                    }
                }
            }, 0L, latencyTrackingInterval);
        }

        public void close() {
            this.latencyMarkTimer.cancel(true);
        }
    }
}

