/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.io.IOException;
import java.util.Map;
import org.apache.flink.annotation.Internal;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.core.io.PostVersionedIOReadableWritable;
import org.apache.flink.core.memory.DataInputView;
import org.apache.flink.core.memory.DataOutputView;
import org.apache.flink.streaming.api.operators.HeapInternalTimerService;
import org.apache.flink.streaming.api.operators.InternalTimeServiceManager;
import org.apache.flink.streaming.api.operators.InternalTimersSnapshot;
import org.apache.flink.streaming.api.operators.InternalTimersSnapshotReaderWriters;
import org.apache.flink.streaming.api.operators.TimerSerializer;
import org.apache.flink.util.Preconditions;

@Internal
public class InternalTimerServiceSerializationProxy<K>
extends PostVersionedIOReadableWritable {
    public static final int VERSION = 1;
    private final InternalTimeServiceManager<K> timerServicesManager;
    private ClassLoader userCodeClassLoader;
    private final int keyGroupIdx;

    public InternalTimerServiceSerializationProxy(InternalTimeServiceManager<K> timerServicesManager, ClassLoader userCodeClassLoader, int keyGroupIdx) {
        this.timerServicesManager = (InternalTimeServiceManager)Preconditions.checkNotNull(timerServicesManager);
        this.userCodeClassLoader = (ClassLoader)Preconditions.checkNotNull((Object)userCodeClassLoader);
        this.keyGroupIdx = keyGroupIdx;
    }

    public InternalTimerServiceSerializationProxy(InternalTimeServiceManager<K> timerServicesManager, int keyGroupIdx) {
        this.timerServicesManager = (InternalTimeServiceManager)Preconditions.checkNotNull(timerServicesManager);
        this.keyGroupIdx = keyGroupIdx;
    }

    public int getVersion() {
        return 1;
    }

    public void write(DataOutputView out) throws IOException {
        super.write(out);
        Map<String, HeapInternalTimerService<K, ?>> registeredTimerServices = this.timerServicesManager.getRegisteredTimerServices();
        out.writeInt(registeredTimerServices.size());
        for (Map.Entry<String, HeapInternalTimerService<K, ?>> entry : registeredTimerServices.entrySet()) {
            String serviceName = entry.getKey();
            HeapInternalTimerService<K, ?> timerService = entry.getValue();
            out.writeUTF(serviceName);
            InternalTimersSnapshotReaderWriters.getWriterForVersion(1, timerService.snapshotTimersForKeyGroup(this.keyGroupIdx)).writeTimersSnapshot(out);
        }
    }

    protected void read(DataInputView in, boolean wasVersioned) throws IOException {
        int noOfTimerServices = in.readInt();
        for (int i = 0; i < noOfTimerServices; ++i) {
            String serviceName = in.readUTF();
            int readerVersion = wasVersioned ? this.getReadVersion() : Integer.MIN_VALUE;
            InternalTimersSnapshot restoredTimersSnapshot = InternalTimersSnapshotReaderWriters.getReaderForVersion(readerVersion, this.userCodeClassLoader).readTimersSnapshot(in);
            HeapInternalTimerService timerService = this.registerOrGetTimerService(serviceName, restoredTimersSnapshot);
            timerService.restoreTimersForKeyGroup(restoredTimersSnapshot, this.keyGroupIdx);
        }
    }

    private <N> HeapInternalTimerService<K, N> registerOrGetTimerService(String serviceName, InternalTimersSnapshot<?, ?> restoredTimersSnapshot) {
        TypeSerializer<?> keySerializer = restoredTimersSnapshot.getKeySerializer();
        TypeSerializer<?> namespaceSerializer = restoredTimersSnapshot.getNamespaceSerializer();
        TimerSerializer timerSerializer = new TimerSerializer(keySerializer, namespaceSerializer);
        return this.timerServicesManager.registerOrGetTimerService(serviceName, timerSerializer);
    }
}

