/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.operators;

import java.lang.reflect.Array;
import javax.annotation.Nonnegative;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.flink.api.common.typeutils.TypeSerializer;
import org.apache.flink.runtime.state.KeyExtractorFunction;
import org.apache.flink.runtime.state.KeyGroupPartitioner;
import org.apache.flink.runtime.state.KeyGroupRange;
import org.apache.flink.runtime.state.StateSnapshot;

public class HeapPriorityQueueStateSnapshot<T>
implements StateSnapshot {
    @Nonnull
    private final KeyExtractorFunction<T> keyExtractor;
    @Nonnull
    private final T[] heapArrayCopy;
    @Nonnull
    private final TypeSerializer<T> elementSerializer;
    @Nonnull
    private final KeyGroupRange keyGroupRange;
    @Nonnegative
    private final int totalKeyGroups;
    @Nullable
    private StateSnapshot.KeyGroupPartitionedSnapshot partitionedSnapshot;

    HeapPriorityQueueStateSnapshot(@Nonnull T[] heapArrayCopy, @Nonnull KeyExtractorFunction<T> keyExtractor, @Nonnull TypeSerializer<T> elementSerializer, @Nonnull KeyGroupRange keyGroupRange, @Nonnegative int totalKeyGroups) {
        assert (elementSerializer.isImmutableType());
        this.keyExtractor = keyExtractor;
        this.heapArrayCopy = heapArrayCopy;
        this.elementSerializer = elementSerializer;
        this.keyGroupRange = keyGroupRange;
        this.totalKeyGroups = totalKeyGroups;
    }

    @Nonnull
    public StateSnapshot.KeyGroupPartitionedSnapshot partitionByKeyGroup() {
        if (this.partitionedSnapshot == null) {
            Object[] partitioningOutput = (Object[])Array.newInstance(this.heapArrayCopy.getClass().getComponentType(), this.heapArrayCopy.length);
            KeyGroupPartitioner keyGroupPartitioner = new KeyGroupPartitioner((Object[])this.heapArrayCopy, this.heapArrayCopy.length, partitioningOutput, this.keyGroupRange, this.totalKeyGroups, this.keyExtractor, (arg_0, arg_1) -> this.elementSerializer.serialize(arg_0, arg_1));
            this.partitionedSnapshot = keyGroupPartitioner.partitionByKeyGroup();
        }
        return this.partitionedSnapshot;
    }

    public void release() {
    }
}

