/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph.util;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;

public class CursorableLinkedList<E>
implements List<E> {
    protected transient Node<E> header = this.createHeaderNode();
    protected transient int size;
    protected transient int modCount;

    public CursorableLinkedList() {
    }

    public CursorableLinkedList(Collection<? extends E> c) {
        this.addAll(c);
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) != -1;
    }

    @Override
    public Iterator<E> iterator() {
        return this.cursor();
    }

    @Override
    public Object[] toArray() {
        return this.toArray(new Object[this.size]);
    }

    @Override
    public <T> T[] toArray(T[] a) {
        if (a.length < this.size) {
            Class<?> componentType = a.getClass().getComponentType();
            a = (Object[])Array.newInstance(componentType, this.size);
        }
        int i = 0;
        Node node = this.header.next;
        while (node != this.header) {
            a[i] = node.value;
            node = node.next;
            ++i;
        }
        if (a.length > this.size) {
            a[this.size] = null;
        }
        return a;
    }

    @Override
    public boolean add(E e) {
        this.addNodeBefore(this.header, e);
        return true;
    }

    @Override
    public boolean remove(Object o) {
        Node node = this.header.next;
        while (node != this.header) {
            if (this.isEqualValue(node.value, o)) {
                this.removeNode(node);
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends E> c) {
        return this.addAll(this.size, c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends E> c) {
        Node<E> node = this.getNode(index, true);
        for (E value : c) {
            this.addNodeBefore(node, value);
        }
        return true;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (!c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean modified = false;
        Iterator<E> it = this.iterator();
        while (it.hasNext()) {
            if (c.contains(it.next())) continue;
            it.remove();
            modified = true;
        }
        return modified;
    }

    @Override
    public void clear() {
        this.removeAllNodes();
    }

    @Override
    public E get(int index) {
        Node<E> node = this.getNode(index, false);
        return node.value;
    }

    @Override
    public E set(int index, E element) {
        Node<E> node = this.getNode(index, false);
        Object oldValue = node.value;
        node.value = element;
        return oldValue;
    }

    @Override
    public void add(int index, E element) {
        Node<E> node = this.getNode(index, true);
        this.addNodeBefore(node, element);
    }

    @Override
    public E remove(int index) {
        Node<E> node = this.getNode(index, false);
        Object oldValue = node.value;
        this.removeNode(node);
        return oldValue;
    }

    @Override
    public int indexOf(Object o) {
        int i = 0;
        Node node = this.header.next;
        while (node != this.header) {
            if (this.isEqualValue(node.value, o)) {
                return i;
            }
            ++i;
            node = node.next;
        }
        return -1;
    }

    @Override
    public int lastIndexOf(Object o) {
        int i = this.size - 1;
        Node node = this.header.previous;
        while (node != this.header) {
            if (this.isEqualValue(node.value, o)) {
                return i;
            }
            --i;
            node = node.previous;
        }
        return -1;
    }

    @Override
    public ListIterator<E> listIterator() {
        return this.cursor();
    }

    @Override
    public ListIterator<E> listIterator(int index) {
        Node<E> node = this.getNode(index, true);
        return new Cursor<E>(this, node);
    }

    @Override
    public List<E> subList(int fromIndex, int toIndex) {
        throw new UnsupportedOperationException();
    }

    public Cursor<E> cursor() {
        return new Cursor<E>(this, this.header);
    }

    public Cursor<E> cursor(Cursor<E> from) {
        this.checkCursor(from);
        return new Cursor(this, ((Cursor)from).current);
    }

    public void add(Cursor<E> cursor, E element) {
        this.checkCursor(cursor);
        if (((Cursor)cursor).current.previous == null) {
            throw new IllegalStateException("The element positioned by the cursor was already removed from the list.");
        }
        this.addNodeBefore(((Cursor)cursor).current, element);
    }

    public void remove(Cursor<E> cursor) {
        this.checkCursor(cursor);
        if (((Cursor)cursor).current.previous != null) {
            this.removeNode(((Cursor)cursor).current);
        }
    }

    private Node<E> createHeaderNode() {
        return new Node();
    }

    private Node<E> addNodeBefore(Node<E> node, E elment) {
        Node newNode = new Node(node.previous, elment, node);
        node.previous.next = newNode;
        node.previous = newNode;
        ++this.size;
        ++this.modCount;
        return newNode;
    }

    private void addNodeBefore(Node<E> node, Node<E> newNode) {
        newNode.previous = node.previous;
        newNode.next = node;
        node.previous.next = newNode;
        node.previous = newNode;
        ++this.size;
        ++this.modCount;
    }

    private Node<E> removeNode(Node<E> node) {
        if (node != this.header) {
            node.previous.next = node.next;
            node.next.previous = node.previous;
            --this.size;
            ++this.modCount;
            node.previous = null;
            node.next = null;
            return node;
        }
        return null;
    }

    private void removeAllNodes() {
        this.header.next = this.header;
        this.header.previous = this.header;
        this.size = 0;
        ++this.modCount;
    }

    private Node<E> getNode(int index, boolean endMarkerAllowed) throws IndexOutOfBoundsException {
        Node<E> node;
        if (index < 0) {
            throw new IndexOutOfBoundsException("Couldn't get the node: index (" + index + ") less than zero.");
        }
        if (!endMarkerAllowed && index == this.size) {
            throw new IndexOutOfBoundsException("Couldn't get the node: index (" + index + ") is the size of the list.");
        }
        if (index > this.size) {
            throw new IndexOutOfBoundsException("Couldn't get the node: index (" + index + ") greater than the size of the list (" + this.size + ").");
        }
        if (index < this.size / 2) {
            node = this.header.next;
            for (int currentIndex = 0; currentIndex < index; ++currentIndex) {
                node = node.next;
            }
        } else {
            node = this.header;
            for (int currentIndex = this.size; currentIndex > index; --currentIndex) {
                node = node.previous;
            }
        }
        return node;
    }

    private boolean isEqualValue(Object value1, Object value2) {
        return value1 == value2 || value1 != null && value1.equals(value2);
    }

    private void checkCursor(Cursor<E> cursor) {
        if (((Cursor)cursor).parent != this) {
            throw new IllegalArgumentException("The cursor does not point to the list.");
        }
    }

    static class Node<E> {
        Node<E> previous;
        Node<E> next;
        E value;

        Node() {
            this.previous = this;
            this.next = this;
        }

        Node(Node<E> previous, E value, Node<E> next) {
            this.previous = previous;
            this.next = next;
            this.value = value;
        }
    }

    public static class Cursor<E>
    implements ListIterator<E> {
        private CursorableLinkedList<E> parent;
        private Node<E> current;

        protected Cursor(CursorableLinkedList parent, Node<E> node) {
            this.parent = parent;
            this.current = node;
        }

        @Override
        public boolean hasNext() {
            return this.current.next != this.parent.header;
        }

        @Override
        public E next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException("No element at next index.");
            }
            this.current = this.current.next;
            return this.current.value;
        }

        @Override
        public boolean hasPrevious() {
            return this.current.previous != this.parent.header;
        }

        @Override
        public E previous() {
            if (!this.hasPrevious()) {
                throw new NoSuchElementException("No element at previous index.");
            }
            this.current = this.current.previous;
            return this.current.value;
        }

        @Override
        public int nextIndex() {
            throw new UnsupportedOperationException("Indexed access is not supported.");
        }

        @Override
        public int previousIndex() {
            throw new UnsupportedOperationException("Indexed access is not supported.");
        }

        @Override
        public void remove() {
            this.parent.remove(this);
        }

        @Override
        public void set(E e) {
            this.current.value = e;
        }

        @Override
        public void add(E e) {
            this.parent.add(this, e);
        }

        public void moveNodeTo(Cursor<E> cursor) {
            this.current = ((CursorableLinkedList)this.parent).removeNode(this.current);
            ((CursorableLinkedList)this.parent).addNodeBefore(cursor.current, this.current);
        }

        public E getValue() {
            if (this.current == this.parent.header) {
                throw new NoSuchElementException("No element at current index.");
            }
            return this.current.value;
        }
    }
}

