/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.graph;

import java.io.Serializable;
import java.util.Objects;
import org.apache.flink.runtime.jobgraph.ControlType;
import org.apache.flink.runtime.jobgraph.EdgeID;
import org.apache.flink.streaming.api.graph.StreamNode;

public class StreamControlEdge
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final EdgeID edgeID;
    private final String edgeName;
    private final int sourceId;
    private final int targetId;
    private final ControlType controlType;
    private final String sourceOperatorName;
    private final String targetOperatorName;

    public StreamControlEdge(StreamNode sourceVertex, StreamNode targetVertex, ControlType controlType) {
        this.sourceId = sourceVertex.getId();
        this.targetId = targetVertex.getId();
        this.controlType = controlType;
        this.sourceOperatorName = sourceVertex.getOperatorName();
        this.targetOperatorName = targetVertex.getOperatorName();
        this.edgeID = new EdgeID();
        this.edgeName = sourceVertex + "_" + targetVertex + "_" + controlType;
    }

    public EdgeID getEdgeID() {
        return this.edgeID;
    }

    public int getSourceId() {
        return this.sourceId;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public ControlType getControlType() {
        return this.controlType;
    }

    public int hashCode() {
        return Objects.hash(this.edgeName, this.edgeID);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamControlEdge that = (StreamControlEdge)o;
        return this.edgeName.equals(that.edgeName) && this.edgeID.equals((Object)that.getEdgeID());
    }

    public String toString() {
        return "(" + this.sourceOperatorName + "-" + this.sourceId + " -> " + this.targetOperatorName + "-" + this.targetId + ", controlType=" + this.controlType.name() + ", edgeID=" + this.edgeID + ')';
    }
}

