/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.environment;

import org.apache.flink.annotation.PublicEvolving;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobID;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.client.program.ContextEnvironment;
import org.apache.flink.client.program.DetachedEnvironment;
import org.apache.flink.optimizer.plan.FlinkPlan;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.graph.StreamGraph;
import org.apache.flink.util.Preconditions;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@PublicEvolving
public class StreamContextEnvironment
extends StreamExecutionEnvironment {
    private static final Logger LOG = LoggerFactory.getLogger(StreamContextEnvironment.class);
    private final ContextEnvironment ctx;

    protected StreamContextEnvironment(ContextEnvironment ctx) {
        this.ctx = ctx;
        if (ctx.getParallelism() > 0) {
            this.setParallelism(ctx.getParallelism());
        }
    }

    @Override
    public JobExecutionResult execute(StreamGraph streamGraph) throws Exception {
        this.transformations.clear();
        if (this.ctx instanceof DetachedEnvironment) {
            LOG.warn("Job was executed in detached mode, the results will be available on completion.");
            ((DetachedEnvironment)this.ctx).setDetachedPlan((FlinkPlan)streamGraph);
            return DetachedEnvironment.DetachedJobExecutionResult.INSTANCE;
        }
        return this.ctx.getClient().run((FlinkPlan)streamGraph, this.ctx.getJars(), this.ctx.getClasspaths(), this.ctx.getLibjars(), this.ctx.getFiles(), this.ctx.getUserCodeClassLoader(), this.ctx.getSavepointRestoreSettings(), false).getJobExecutionResult();
    }

    @Override
    protected JobSubmissionResult executeInternal(String jobName, boolean detached, SavepointRestoreSettings savepointRestoreSettings) throws Exception {
        Preconditions.checkNotNull((Object)jobName, (String)"Streaming Job name should not be null.");
        StreamGraph streamGraph = this.getStreamGraph();
        streamGraph.setJobName(jobName);
        this.transformations.clear();
        if (this.ctx instanceof DetachedEnvironment) {
            LOG.warn("Job was executed in detached mode, the results will be available on completion.");
            ((DetachedEnvironment)this.ctx).setDetachedPlan((FlinkPlan)streamGraph);
            return DetachedEnvironment.DetachedJobExecutionResult.INSTANCE;
        }
        JobSubmissionResult jobSubmissionResult = this.ctx.getClient().run((FlinkPlan)streamGraph, this.ctx.getJars(), this.ctx.getClasspaths(), this.ctx.getLibjars(), this.ctx.getFiles(), this.ctx.getUserCodeClassLoader(), this.ctx.getSavepointRestoreSettings(), detached);
        if (detached) {
            return jobSubmissionResult;
        }
        return jobSubmissionResult.getJobExecutionResult();
    }

    @Override
    public void stopJob(JobID jobID) throws Exception {
        this.ctx.getClient().stop(jobID);
    }

    @Override
    public void cancel(String jobId) {
    }

    @Override
    public String triggerSavepoint(String jobId, String path) {
        return null;
    }
}

