/*
 * Decompiled with CFR 0.152.
 */
package org.apache.flink.streaming.api.driver;

import java.net.URL;
import org.apache.flink.api.common.JobExecutionResult;
import org.apache.flink.api.common.JobSubmissionResult;
import org.apache.flink.client.program.ProgramInvocationException;
import org.apache.flink.configuration.Configuration;
import org.apache.flink.runtime.jobgraph.SavepointRestoreSettings;
import org.apache.flink.streaming.api.environment.RemoteStreamEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironment;
import org.apache.flink.streaming.api.environment.StreamExecutionEnvironmentFactory;
import org.apache.flink.streaming.api.graph.StreamGraph;

public class DriverStreamEnvironment
extends RemoteStreamEnvironment {
    private final String driverId;

    public DriverStreamEnvironment(String host, int port, String driverId, String[] jarFiles, URL[] globalClasspaths, Configuration configuration) {
        super(host, port, configuration, jarFiles, globalClasspaths);
        this.driverId = driverId;
    }

    public void setAsContext() {
        StreamExecutionEnvironmentFactory factory = () -> this;
        StreamExecutionEnvironment.initializeContextEnvironment(factory);
    }

    public void resetContextEnvironments() {
        StreamExecutionEnvironment.resetContextEnvironment();
    }

    @Override
    public JobExecutionResult execute(String jobName) throws Exception {
        SavepointRestoreSettings savepointRestoreSettings = this.getJobSavePointSettingsFromConfiguration();
        return this.executeInternal(jobName, false, savepointRestoreSettings).getJobExecutionResult();
    }

    @Override
    public JobSubmissionResult submit(String jobName) throws Exception {
        SavepointRestoreSettings savepointRestoreSettings = this.getJobSavePointSettingsFromConfiguration();
        return this.executeInternal(jobName, true, savepointRestoreSettings);
    }

    @Override
    protected JobSubmissionResult executeInternal(String jobName, boolean detached, SavepointRestoreSettings savepointRestoreSettings) throws ProgramInvocationException {
        StreamGraph streamGraph = this.getStreamGraph();
        String newJobName = this.driverId + "_" + jobName;
        streamGraph.setJobName(newJobName);
        this.transformations.clear();
        JobSubmissionResult submissionResult = this.executeRemotely(streamGraph, this.jarFiles, detached, savepointRestoreSettings);
        return submissionResult;
    }

    private SavepointRestoreSettings getJobSavePointSettingsFromConfiguration() {
        Configuration clientConfiguration = this.getClientConfiguration();
        String savepointRestorePath = clientConfiguration.getString("flink.driver.savepointrestoresettings.path", null);
        boolean allowNonRestoredState = clientConfiguration.getBoolean("flink.driver.savepointrestoresettings.allowNonRestoredState", false);
        boolean resumeFromLatestCheckpoint = clientConfiguration.getBoolean("flink.driver.savepointrestoresettings.resumeFromLatestCheckpoint", false);
        if (savepointRestorePath == null) {
            return SavepointRestoreSettings.none();
        }
        if (resumeFromLatestCheckpoint) {
            return SavepointRestoreSettings.forResumePath((String)savepointRestorePath, (boolean)allowNonRestoredState);
        }
        return SavepointRestoreSettings.forPath((String)savepointRestorePath, (boolean)allowNonRestoredState);
    }
}

